/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record.color;

import java.awt.Color;

public interface ColorSpaceType {
    public static final ColorSpaceType RedGreenBlue = new ColorSpaceType(){

        @Override
        public void fromRGB(float[] components) {
        }

        @Override
        public void toRGB(float[] components) {
        }
    };
    public static final ColorSpaceType HueSaturationBrightness = new ColorSpaceType(){

        @Override
        public void fromRGB(float[] components) {
            Color rgb = new Color(components[0], components[1], components[2]);
            Color.RGBtoHSB(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), components);
        }

        @Override
        public void toRGB(float[] components) {
            int rgb = Color.HSBtoRGB(components[0], components[1], components[2]);
            components[0] = (float)(rgb >> 16 & 0xFF) / 255.0f;
            components[1] = (float)(rgb >> 8 & 0xFF) / 255.0f;
            components[2] = (float)(rgb >> 0 & 0xFF) / 255.0f;
        }
    };
    public static final ColorSpaceType YUV = new ColorSpaceType(){

        @Override
        public void fromRGB(float[] components) {
            int R = (int)(components[0] * 255.5f);
            int G = (int)(components[1] * 255.5f);
            int B = (int)(components[2] * 255.5f);
            int Y = (66 * R + 129 * G + 25 * B + 128 >> 8) + 16;
            int U = (-38 * R - 74 * G + 112 * B + 128 >> 8) + 128;
            int V = (112 * R - 94 * G - 18 * B + 128 >> 8) + 128;
            components[0] = (float)Y / 255.5f;
            components[1] = (float)U / 255.5f;
            components[2] = (float)V / 255.5f;
        }

        @Override
        public void toRGB(float[] components) {
            int Y = (int)(components[0] * 255.5f);
            int U = (int)(components[1] * 255.5f);
            int V = (int)(components[2] * 255.5f);
            int C = Y - 16;
            int D = U - 128;
            int E = V - 128;
            int R = this.clip(298 * C + 409 * E + 128 >> 8);
            int G = this.clip(298 * C - 100 * D - 208 * E + 128 >> 8);
            int B = this.clip(298 * C + 516 * D + 128 >> 8);
            components[0] = (float)R / 255.5f;
            components[1] = (float)G / 255.5f;
            components[2] = (float)B / 255.5f;
        }

        private int clip(int i) {
            if (i < 0) {
                return 0;
            }
            if (i > 255) {
                return 255;
            }
            return i;
        }
    };
    public static final ColorSpaceType HueSaturationLightness = new ColorSpaceType(){

        @Override
        public void fromRGB(float[] components) {
            float r = components[0];
            float g = components[1];
            float b = components[2];
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            float h = 0.0f;
            if (max == min) {
                h = 0.0f;
            } else if (max == r) {
                h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
            } else if (max == g) {
                h = 60.0f * (b - r) / (max - min) + 120.0f;
            } else if (max == b) {
                h = 60.0f * (r - g) / (max - min) + 240.0f;
            }
            float l = (max + min) / 2.0f;
            float s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
            components[0] = h / 360.0f;
            components[1] = s;
            components[2] = l;
        }

        @Override
        public void toRGB(float[] components) {
            float h = components[0];
            float s = components[1];
            float l = components[2];
            float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - s * l;
            float p = 2.0f * l - q;
            components[0] = Math.max(0.0f, this.HueToRGB(p, q, h + 0.33333334f));
            components[1] = Math.max(0.0f, this.HueToRGB(p, q, h));
            components[2] = Math.max(0.0f, this.HueToRGB(p, q, h - 0.33333334f));
        }

        private float HueToRGB(float p, float q, float h) {
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
            if (6.0f * h < 1.0f) {
                return p + (q - p) * 6.0f * h;
            }
            if (2.0f * h < 1.0f) {
                return q;
            }
            if (3.0f * h < 2.0f) {
                return p + (q - p) * 6.0f * (0.6666667f - h);
            }
            return p;
        }
    };
    public static final ColorSpaceType sRGB = new ColorSpaceType(){

        @Override
        public void fromRGB(float[] components) {
            components[0] = this.toNonLinear(components[0]);
            components[1] = this.toNonLinear(components[1]);
            components[2] = this.toNonLinear(components[2]);
        }

        @Override
        public void toRGB(float[] components) {
            components[0] = this.toLinear(components[0]);
            components[1] = this.toLinear(components[1]);
            components[2] = this.toLinear(components[2]);
        }

        private float toNonLinear(float f) {
            if (f < 0.0f) {
                return 0.0f;
            }
            if (f > 1.0f) {
                return 1.0f;
            }
            if ((double)f <= 0.04045) {
                return f / 12.92f;
            }
            return (float)Math.pow((f + 0.055f) / 1.055f, 2.4f);
        }

        private float toLinear(float f) {
            if (f < 0.0f) {
                return 0.0f;
            }
            if (f >= 1.0f) {
                return 1.0f;
            }
            if ((double)f <= 0.0031308) {
                return f * 12.92f;
            }
            return (float)((double)1.055f * Math.pow(f, 0.4166666567325592)) - 0.055f;
        }
    };

    public void fromRGB(float[] var1);

    public void toRGB(float[] var1);
}

