/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record.color;

import com.benryan.pptx.record.color.Adjustment;
import com.benryan.pptx.record.color.ColorSpaceType;
import com.benryan.pptx.record.color.ComplementAdjustment;
import com.benryan.pptx.record.color.FactorModificationAdjustment;
import com.benryan.pptx.record.color.FactorOffsetAdjustment;
import com.benryan.pptx.record.color.FactorSettingAdjustment;
import com.benryan.pptx.record.color.GammaAdjustment;
import com.benryan.pptx.record.color.InverseGammaAdjustment;
import com.benryan.pptx.record.color.InvertAdjustment;
import com.benryan.pptx.record.color.ShadeAdjustment;
import com.benryan.pptx.record.color.TintAdjustment;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import org.apache.xmlbeans.XmlObject;

public class ColorAdjustments {
    private Collection<Adjustment> adjustments = Arrays.asList(new FactorSettingAdjustment("red", ColorSpaceType.RedGreenBlue, 0), new FactorSettingAdjustment("green", ColorSpaceType.RedGreenBlue, 1), new FactorSettingAdjustment("blue", ColorSpaceType.RedGreenBlue, 2), new FactorSettingAdjustment("alpha", ColorSpaceType.RedGreenBlue, 3), new FactorSettingAdjustment("hue", ColorSpaceType.HueSaturationLightness, 0), new FactorSettingAdjustment("sat", ColorSpaceType.HueSaturationLightness, 1), new FactorSettingAdjustment("lum", ColorSpaceType.HueSaturationLightness, 2), new FactorModificationAdjustment("redMod", ColorSpaceType.RedGreenBlue, 0), new FactorModificationAdjustment("greenMod", ColorSpaceType.RedGreenBlue, 1), new FactorModificationAdjustment("blueMod", ColorSpaceType.RedGreenBlue, 2), new FactorModificationAdjustment("alphaMod", ColorSpaceType.RedGreenBlue, 3), new FactorModificationAdjustment("hueMod", ColorSpaceType.HueSaturationLightness, 0), new FactorModificationAdjustment("satMod", ColorSpaceType.HueSaturationLightness, 1), new FactorModificationAdjustment("lumMod", ColorSpaceType.HueSaturationLightness, 2), new FactorOffsetAdjustment("redOff", ColorSpaceType.RedGreenBlue, 0), new FactorOffsetAdjustment("greenOff", ColorSpaceType.RedGreenBlue, 1), new FactorOffsetAdjustment("blueOff", ColorSpaceType.RedGreenBlue, 2), new FactorOffsetAdjustment("alphaOff", ColorSpaceType.RedGreenBlue, 3), new FactorOffsetAdjustment("hueOff", ColorSpaceType.HueSaturationLightness, 0), new FactorOffsetAdjustment("satOff", ColorSpaceType.HueSaturationLightness, 1), new FactorOffsetAdjustment("lumOff", ColorSpaceType.HueSaturationLightness, 2), new ShadeAdjustment(), new TintAdjustment(), new InvertAdjustment(), new ComplementAdjustment(), new GammaAdjustment(), new InverseGammaAdjustment());
    private static ColorAdjustments instance = new ColorAdjustments();

    public static Color adjust(Color raw, XmlObject adjustmentParameters) {
        return instance.adjustInternal(raw, adjustmentParameters);
    }

    private Color adjustInternal(Color raw, XmlObject adjustmentParameters) {
        Color current = raw;
        for (Adjustment adjustment : this.adjustments) {
            XmlObject value = this.getDrawMLChildValue(adjustmentParameters, adjustment.getName());
            if (value == null) continue;
            current = this.applyAdjustment(adjustment, value, current);
        }
        return current;
    }

    private Color applyAdjustment(Adjustment adjustment, XmlObject value, Color current) {
        float[] components = new float[4];
        current.getColorComponents(components);
        components[3] = (float)current.getAlpha() / 255.0f;
        ColorSpaceType requiredColorSpaceType = adjustment.requiredColorSpace();
        requiredColorSpaceType.fromRGB(components);
        adjustment.adjust(components, value);
        requiredColorSpaceType.toRGB(components);
        components[0] = this.pin(0.0f, 1.0f, components[0]);
        components[1] = this.pin(0.0f, 1.0f, components[1]);
        components[2] = this.pin(0.0f, 1.0f, components[2]);
        components[3] = this.pin(0.0f, 1.0f, components[3]);
        return new Color(components[0], components[1], components[2], components[3]);
    }

    private float pin(float min, float max, float val) {
        return Math.min(max, Math.max(min, val));
    }

    protected XmlObject getDrawMLChildValue(XmlObject xml, String childName) {
        XmlObject[] children = xml.selectChildren("http://schemas.openxmlformats.org/drawingml/2006/main", childName);
        if (children.length > 1) {
            throw new IllegalArgumentException(xml + " has more than one child node named " + childName);
        }
        if (children.length == 0) {
            return null;
        }
        return children[0].selectAttribute(null, "val");
    }
}

