/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.usermodel.EscherCharacterRun;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLCharacterStyle;
import com.benryan.pptx.record.XMLParagraphStyle;
import java.awt.Color;
import java.awt.Paint;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;

class XMLTextRun
implements EscherCharacterRun {
    protected String text;
    protected XMLCharacterStyle textProps;
    protected XMLParagraphStyle paragraphStyle;
    protected int startIndex;

    protected XMLTextRun() {
    }

    XMLTextRun(int currentOffset, XMLParagraphStyle paragraphStyle, CTTextCharacterProperties runProperties, String text, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        this.text = text;
        this.paragraphStyle = paragraphStyle;
        this.startIndex = currentOffset;
        XMLCharacterStyle defaultStyle = paragraphStyle.getTextProps();
        if (defaultStyle == null) {
            this.textProps = new XMLCharacterStyle(runProperties, mainPart, slideShow, theme, colorScheme);
        } else if (runProperties != null) {
            try {
                this.textProps = (XMLCharacterStyle)defaultStyle.clone();
                this.textProps.initProps(runProperties, mainPart, slideShow, theme, colorScheme);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.textProps = defaultStyle;
        }
    }

    @Override
    public int getIndentLevel() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getTextPosition() {
        return 0;
    }

    @Override
    public int getAlignment() {
        return this.paragraphStyle.getAlignment();
    }

    @Override
    public char getBulletChar() {
        return this.paragraphStyle.getBulletChar();
    }

    @Override
    public Color getBulletColor() {
        Color c = this.paragraphStyle.getBulletColor();
        if (c == null) {
            c = this.getFontColor();
        }
        return c;
    }

    @Override
    public String getBulletFontName() {
        return this.paragraphStyle.getBulletFontName();
    }

    @Override
    public int getBulletOffset() {
        return this.paragraphStyle.getBulletOffset();
    }

    @Override
    public double getBulletSize() {
        return this.paragraphStyle.getBulletSize();
    }

    @Override
    public Color getFontColor() {
        Paint p = this.textProps.getFill().getFill();
        if (p instanceof Color) {
            return (Color)p;
        }
        return Color.black;
    }

    @Override
    public String getFontName() {
        return this.textProps.getFontName();
    }

    @Override
    public int getFontSize() {
        return (int)this.textProps.getFontSize();
    }

    @Override
    public double getLineSpacing() {
        return this.paragraphStyle.getLineSpacing();
    }

    @Override
    public double getSpaceAfter() {
        return this.paragraphStyle.getSpaceAfter();
    }

    @Override
    public double getSpaceBefore() {
        return this.paragraphStyle.getSpaceBefore();
    }

    @Override
    public int getTextOffset() {
        return this.paragraphStyle.getTextOffset();
    }

    @Override
    public boolean isBold() {
        return this.textProps.isBold();
    }

    @Override
    public boolean isBullet() {
        return this.paragraphStyle.isBullet();
    }

    @Override
    public boolean isItalic() {
        return this.textProps.isItalic();
    }

    @Override
    public boolean isUnderlined() {
        return this.textProps.isUnderlined();
    }
}

