/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.CellType;
import com.benryan.pptx.record.XMLTableCellStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTablePartStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyle;

public class XMLTableStyle {
    private CTTableStyle tableStyle;

    public XMLTableStyle(CTTableStyle tableStyle) {
        this.tableStyle = tableStyle;
    }

    public XMLTableCellStyle getCellStyle(CellType type, AbstractSlideModel slide) {
        XMLTableCellStyle defaultStyle = this.loadCellStyle(this.tableStyle.getWholeTbl(), null, slide);
        switch (type) {
            case DEFAULT: {
                return defaultStyle;
            }
            case FIRST_ROW: {
                return this.loadCellStyle(this.tableStyle.getFirstRow(), defaultStyle, slide);
            }
            case LAST_ROW: {
                return this.loadCellStyle(this.tableStyle.getLastRow(), defaultStyle, slide);
            }
            case FIRST_COL: {
                return this.loadCellStyle(this.tableStyle.getFirstCol(), defaultStyle, slide);
            }
            case LAST_COL: {
                return this.loadCellStyle(this.tableStyle.getLastCol(), defaultStyle, slide);
            }
            case HBAND1: {
                return this.loadCellStyle(this.tableStyle.getBand1H(), defaultStyle, slide);
            }
            case HBAND2: {
                return this.loadCellStyle(this.tableStyle.getBand2H(), defaultStyle, slide);
            }
            case VBAND1: {
                return this.loadCellStyle(this.tableStyle.getBand1V(), defaultStyle, slide);
            }
            case VBAND2: {
                return this.loadCellStyle(this.tableStyle.getBand2V(), defaultStyle, slide);
            }
        }
        return null;
    }

    private XMLTableCellStyle loadCellStyle(CTTablePartStyle partStyle, XMLTableCellStyle base, AbstractSlideModel slide) {
        if (partStyle != null) {
            if (base == null) {
                return new XMLTableCellStyle(partStyle, slide);
            }
            XMLTableCellStyle xmlTableCellStyle = new XMLTableCellStyle(base);
            xmlTableCellStyle.initProps(partStyle, slide);
            return xmlTableCellStyle;
        }
        return null;
    }
}

