/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.FillProperties;
import com.benryan.pptx.record.LineProperties;
import com.benryan.pptx.record.XMLCharacterStyle;
import java.awt.Paint;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCellBorderStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTablePartStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyleCellStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyleTextStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTThemeableLineStyle;

public class XMLTableCellStyle {
    private Paint cellFill;
    private LineProperties[] borders = new LineProperties[6];
    private XMLCharacterStyle textStyle;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    public static final int HORZ = 4;
    public static final int VERT = 5;

    public XMLTableCellStyle(XMLTableCellStyle baseStyle) {
        this.cellFill = baseStyle.cellFill;
        this.borders = baseStyle.borders;
        this.textStyle = baseStyle.textStyle;
    }

    public XMLTableCellStyle(CTTablePartStyle tablePartStyle, AbstractSlideModel slide) {
        this.initProps(tablePartStyle, slide);
    }

    public void initProps(CTTablePartStyle tablePartStyle, AbstractSlideModel slide) {
        CTTableStyleTextStyle tcTxStyle;
        CTTableStyleCellStyle tcStyle = tablePartStyle.getTcStyle();
        if (tcStyle != null) {
            Paint fill = FillProperties.getFillColor((XmlObject)tcStyle.getFill(), tcStyle.getFillRef(), slide);
            if (fill != null) {
                this.cellFill = fill;
            }
            this.initBorders(tcStyle.getTcBdr(), slide);
        }
        if ((tcTxStyle = tablePartStyle.getTcTxStyle()) != null) {
            if (this.textStyle == null) {
                this.textStyle = new XMLCharacterStyle(tcTxStyle, slide);
            } else {
                this.textStyle.initPropsFromTable(tcTxStyle, slide);
            }
        }
    }

    private void initBorders(CTTableCellBorderStyle tcBdr, AbstractSlideModel slide) {
        if (tcBdr != null) {
            CTThemeableLineStyle top = tcBdr.getTop();
            this.loadBorder(top, 0, slide);
            CTThemeableLineStyle left = tcBdr.getLeft();
            this.loadBorder(left, 1, slide);
            CTThemeableLineStyle right = tcBdr.getRight();
            this.loadBorder(right, 3, slide);
            CTThemeableLineStyle bottom = tcBdr.getBottom();
            this.loadBorder(bottom, 2, slide);
            CTThemeableLineStyle horz = tcBdr.getInsideH();
            this.loadBorder(horz, 4, slide);
            CTThemeableLineStyle vert = tcBdr.getInsideV();
            this.loadBorder(vert, 5, slide);
        }
    }

    private void loadBorder(CTThemeableLineStyle lineStyle, int index, AbstractSlideModel slide) {
        if (lineStyle != null) {
            this.borders[index] = LineProperties.create(lineStyle.getLn(), lineStyle.getLnRef(), slide);
        }
    }

    public LineProperties getBorder(int index) {
        return this.borders[index];
    }

    public Paint getFill() {
        return this.cellFill;
    }
}

