/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.escher.CustomShapeRenderer;
import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.ppt.api.ILine;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.usermodel.Paragraph;
import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.gen.xml.XMLShapeFinder;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.LineProperties;
import com.benryan.pptx.record.TextUtils;
import com.benryan.pptx.record.XMLParagraphFactory;
import com.benryan.pptx.record.XMLParagraphStyle;
import com.benryan.pptx.record.XMLShape;
import com.benryan.pptx.record.XMLTableCellBorder;
import com.benryan.pptx.record.XMLTableCellStyle;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCellProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;

public class XMLTableCell
implements IAutoShape,
ITextBox,
EscherHostTextContainer {
    private CTTableCell cell;
    private Rectangle2D.Double anchor;
    private XMLTableCellStyle style;
    private AbstractSlideModel slide;
    private int vertAlign;
    private int topMargin;
    private int bottomMargin;
    private int rightMargin;
    private int leftMargin;
    private int wordWrap;
    private Point tablePosition;
    private Point tableMax;

    public XMLTableCell(CTTableCell cell, XMLTableCellStyle style, AbstractSlideModel slide, Rectangle2D.Double anchor, Point tablePosition, Point tableMax) {
        this.cell = cell;
        this.anchor = anchor;
        this.slide = slide;
        this.style = style;
        this.tablePosition = tablePosition;
        this.tableMax = tableMax;
    }

    @Override
    public boolean doesShapeHaveText() {
        return TextUtils.doesShapeHaveText(this.cell.getTxBody());
    }

    @Override
    public CustomShapeRenderer getCustomShapeRenderer() {
        return null;
    }

    @Override
    public Paint getFillColor() {
        CTTableCellProperties cellProps = this.cell.getTcPr();
        CTSolidColorFillProperties solidFill = cellProps.getSolidFill();
        if (solidFill != null) {
            return ColorScheme.resolveColor((XmlObject)solidFill, this.slide.getColorScheme());
        }
        CTGradientFillProperties gradFill = cellProps.getGradFill();
        if (gradFill != null) {
            CTGradientStopList gsLst = gradFill.getGsLst();
            return ColorScheme.resolveColor((XmlObject)gsLst.getGsArray(0), this.slide.getColorScheme());
        }
        return this.style != null ? this.style.getFill() : null;
    }

    @Override
    public Color getLineColor() {
        return null;
    }

    @Override
    public double getLineWidth() {
        return 0.0;
    }

    @Override
    public Autoshape getPredefinedShape(Rectangle2D rec) {
        return XMLShapeFinder.getAutoShape("rect");
    }

    @Override
    public ITextBox getTextBox() {
        return this;
    }

    @Override
    public boolean isUserDefined() {
        return false;
    }

    @Override
    public AffineTransform createAutoShapeTransform(Rectangle2D logicalRec, Rectangle2D rec, AffineTransform oldt) {
        return XMLShape.createTransform(this, logicalRec, rec, oldt);
    }

    @Override
    public Rectangle2D getAnchor() {
        return this.anchor;
    }

    @Override
    public float getRotation() {
        return 0.0f;
    }

    @Override
    public boolean isBackgroundShape() {
        return false;
    }

    @Override
    public boolean isHFlipped() {
        return false;
    }

    @Override
    public boolean isVFlipped() {
        return false;
    }

    @Override
    public EscherHostTextContainer getEscherHostTextContainer() {
        return this;
    }

    @Override
    public int getMarginBottom() {
        return this.bottomMargin;
    }

    @Override
    public int getMarginLeft() {
        return this.leftMargin;
    }

    @Override
    public int getMarginRight() {
        return this.rightMargin;
    }

    @Override
    public int getMarginTop() {
        return this.topMargin;
    }

    @Override
    public Rectangle2D getTextRectangle(Rectangle2D anchor) {
        return anchor;
    }

    @Override
    public int getVerticalAlignment() {
        return this.vertAlign;
    }

    @Override
    public int getWordWrap() {
        return this.wordWrap;
    }

    @Override
    public boolean shouldRender(boolean isMaster) {
        return true;
    }

    @Override
    public int getDefaultVertAlign() {
        return 0;
    }

    @Override
    public List<Paragraph> getParagraphs() {
        CTTextBody textBody = this.cell.getTxBody();
        if (textBody == null) {
            return Collections.emptyList();
        }
        CTTextBodyProperties bodyPr = textBody.getBodyPr();
        if (bodyPr != null) {
            this.loadBodyProps(bodyPr);
        }
        ArrayList<Paragraph> rv = new ArrayList<Paragraph>();
        CTTextListStyle lstStyle = textBody.getLstStyle();
        Object defaultStyles = null;
        Map<Integer, XMLParagraphStyle> listStyles = null;
        listStyles = this.slide.getSlideMaster().getDefaultStyles();
        if (lstStyle != null && !lstStyle.isNil()) {
            this.slide.loadListLevels(lstStyle, listStyles, listStyles);
        }
        for (CTTextParagraph paragraphElement : textBody.getPArray()) {
            XMLParagraphStyle defaultStyle = null;
            CTTextParagraphProperties pPr = paragraphElement.getPPr();
            int lvl = 0;
            if (pPr != null && pPr.isSetLvl()) {
                lvl = pPr.getLvl();
            }
            defaultStyle = listStyles.get(lvl);
            rv.addAll(XMLParagraphFactory.createParagraphs(defaultStyle, paragraphElement, this.slide.getPackagePart(), this.slide.getSlideShow(), this.slide.getTheme(), this.slide.getColorScheme(), textBody.getBodyPr(), textBody.getLstStyle()));
        }
        return rv;
    }

    private void loadBodyProps(CTTextBodyProperties bodyPr) {
        CTTableCellProperties tcPr;
        if (bodyPr == null) {
            return;
        }
        if (bodyPr.isSetAnchor()) {
            STTextAnchoringType.Enum anchor = bodyPr.getAnchor();
            this.vertAlign = anchor == STTextAnchoringType.B ? 2 : (anchor == STTextAnchoringType.CTR ? 1 : 0);
        }
        if (bodyPr.isSetTIns()) {
            this.topMargin = bodyPr.getTIns() / 9525;
        }
        if (bodyPr.isSetBIns()) {
            this.bottomMargin = bodyPr.getBIns() / 9525;
        }
        if (bodyPr.isSetRIns()) {
            this.rightMargin = bodyPr.getRIns() / 9525;
        }
        if (bodyPr.isSetLIns()) {
            this.leftMargin = bodyPr.getLIns() / 9525;
        }
        if (bodyPr.isSetWrap() && bodyPr.getWrap() == STTextWrappingType.NONE) {
            this.wordWrap = 2;
        }
        if ((tcPr = this.cell.getTcPr()) != null) {
            if (tcPr.isSetAnchor()) {
                STTextAnchoringType.Enum anchor = tcPr.getAnchor();
                this.vertAlign = anchor == STTextAnchoringType.B ? 2 : (anchor == STTextAnchoringType.CTR ? 1 : 0);
            }
            if (tcPr.isSetMarT()) {
                this.topMargin = tcPr.getMarT() / 9525;
            }
            if (tcPr.isSetMarB()) {
                this.bottomMargin = tcPr.getMarB() / 9525;
            }
            if (tcPr.isSetMarR()) {
                this.rightMargin = tcPr.getMarR() / 9525;
            }
            if (tcPr.isSetMarL()) {
                this.leftMargin = tcPr.getMarL() / 9525;
            }
        }
    }

    public Collection<ILine> getBorders() {
        CTTableCellProperties tcPr;
        ArrayList<ILine> borders = new ArrayList<ILine>();
        LineProperties topBorderDefaults = null;
        LineProperties leftBorderDefaults = null;
        LineProperties bottomBorderDefaults = null;
        LineProperties rightBorderDefaults = null;
        if (this.style != null) {
            topBorderDefaults = this.tablePosition.y == 0 ? this.style.getBorder(0) : this.style.getBorder(4);
            leftBorderDefaults = this.tablePosition.x == 0 ? this.style.getBorder(1) : this.style.getBorder(5);
            bottomBorderDefaults = this.tablePosition.y == this.tableMax.y - 1 ? this.style.getBorder(2) : this.style.getBorder(4);
            rightBorderDefaults = this.tablePosition.x == this.tableMax.x - 1 ? this.style.getBorder(3) : this.style.getBorder(5);
        }
        if ((tcPr = this.cell.getTcPr()) != null) {
            Rectangle2D.Double topAnchor = new Rectangle2D.Double(this.anchor.x, this.anchor.y, this.anchor.width, 0.0);
            CTLineProperties lnT = tcPr.getLnT();
            this.createBorder(borders, lnT, topBorderDefaults, topAnchor);
            Rectangle2D.Double leftAnchor = new Rectangle2D.Double(this.anchor.x, this.anchor.y, 0.0, this.anchor.height);
            CTLineProperties lnL = tcPr.getLnL();
            this.createBorder(borders, lnL, leftBorderDefaults, leftAnchor);
            Rectangle2D.Double bottomAnchor = new Rectangle2D.Double(this.anchor.x, this.anchor.y + this.anchor.height, this.anchor.width, 0.0);
            CTLineProperties lnB = tcPr.getLnB();
            this.createBorder(borders, lnB, bottomBorderDefaults, bottomAnchor);
            Rectangle2D.Double rightAnchor = new Rectangle2D.Double(this.anchor.x + this.anchor.width, this.anchor.y, 0.0, this.anchor.height);
            CTLineProperties lnR = tcPr.getLnR();
            this.createBorder(borders, lnR, rightBorderDefaults, rightAnchor);
        }
        return borders;
    }

    private void createBorder(ArrayList<ILine> borders, CTLineProperties lnProps, LineProperties defaults, Rectangle2D.Double bounds) {
        if (lnProps != null) {
            LineProperties topBorderProps = new LineProperties(defaults);
            topBorderProps.setProperties(lnProps, this.slide.getColorScheme());
            borders.add(new XMLTableCellBorder(topBorderProps, bounds));
        } else if (defaults != null) {
            borders.add(new XMLTableCellBorder(defaults, bounds));
        }
    }
}

