/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.escher.api.usermodel.IShapeGroup;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.Transformer;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.XMLCellStyleFinder;
import com.benryan.pptx.record.XMLShape;
import com.benryan.pptx.record.XMLTableCell;
import com.benryan.pptx.record.XMLTableCellStyle;
import com.benryan.pptx.record.XMLTableStyle;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCol;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableGrid;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableRow;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;

public class XMLTable
implements IShapeGroup {
    private CTTable tbl;
    private CTTransform2D xfrm;
    private Rectangle2D.Double anchor;
    private List<IShape> shapes;

    public XMLTable(CTGraphicalObjectFrame frame, AbstractSlideModel slide, CTTable tbl) {
        this.xfrm = frame.getXfrm();
        this.tbl = tbl;
        this.shapes = new ArrayList<IShape>();
        CTPoint2D offset = this.xfrm.getOff();
        CTPositiveSize2D extent = this.xfrm.getExt();
        Rectangle recAnchor = new Rectangle((int)offset.getX(), (int)offset.getY(), (int)extent.getCx(), (int)extent.getCy());
        this.anchor = Transformer.transformRectangle(recAnchor);
        CTTableGrid tblGrid = tbl.getTblGrid();
        CTTableCol[] gridColArray = tblGrid.getGridColArray();
        double[] cellPositions = new double[gridColArray.length];
        cellPositions[0] = (double)this.xfrm.getOff().getX() / 9525.0;
        for (int x = 1; x < cellPositions.length; ++x) {
            cellPositions[x] = cellPositions[x - 1] + (double)gridColArray[x - 1].getW() / 9525.0;
        }
        CTTableProperties tblPr = tbl.getTblPr();
        String tableStyleId = tblPr.getTableStyleId();
        XMLTableStyle style = slide.getSlideShow().getTableStyle(tableStyleId);
        XMLCellStyleFinder styleFinder = new XMLCellStyleFinder(tblPr, style, slide);
        CTTableRow[] trArray = tbl.getTrArray();
        Point tableMax = new Point(cellPositions.length, trArray.length);
        double currentY = (double)this.xfrm.getOff().getY() / 9525.0;
        for (int x = 0; x < trArray.length; ++x) {
            CTTableRow tableRow = trArray[x];
            double height = (double)tableRow.getH() / 9525.0;
            CTTableCell[] tcArray = tableRow.getTcArray();
            for (int y = 0; y < tcArray.length; ++y) {
                if (tcArray[y].getHMerge() || tcArray[y].getVMerge()) continue;
                XMLTableCellStyle cellStyle = styleFinder.findStyle(x, y, trArray.length, tcArray.length);
                Rectangle2D.Double anchor = this.calcCellBounds(tcArray[y], gridColArray, trArray, cellPositions, currentY, height, y, x);
                XMLTableCell cell = new XMLTableCell(tcArray[y], cellStyle, slide, anchor, new Point(y, x), tableMax);
                this.shapes.add(cell);
                this.shapes.addAll(cell.getBorders());
            }
            currentY += height;
        }
    }

    private Rectangle2D.Double calcCellBounds(CTTableCell cell, CTTableCol[] gridColArray, CTTableRow[] tableRows, double[] cellPositions, double currentY, double rowHeight, int col, int row) {
        int x;
        int remaining;
        double cellWidth = (double)gridColArray[col].getW() / 9525.0;
        if (cell.isSetGridSpan()) {
            remaining = cell.getGridSpan() - 1;
            for (x = 0; x < remaining; ++x) {
                cellWidth += (double)gridColArray[col + x].getW() / 9525.0;
            }
        }
        if (cell.isSetRowSpan()) {
            remaining = cell.getRowSpan() - 1;
            for (x = 0; x < remaining; ++x) {
                CTTableRow tableRow = tableRows[row + x];
                rowHeight += (double)tableRow.getH() / 9525.0;
            }
        }
        Rectangle2D.Double anchor = new Rectangle2D.Double(cellPositions[col], currentY, cellWidth, rowHeight);
        return anchor;
    }

    @Override
    public AffineTransform getChildTransform(AffineTransform anchorTransform) {
        return anchorTransform != null ? anchorTransform : new AffineTransform();
    }

    @Override
    public IShape[] getShapes() {
        return this.shapes.toArray(new IShape[this.shapes.size()]);
    }

    @Override
    public Rectangle2D getTransformedAnchor() {
        return this.getAnchor();
    }

    @Override
    public AffineTransform createAutoShapeTransform(Rectangle2D logicalRec, Rectangle2D rec, AffineTransform oldt) {
        return XMLShape.createTransform(this, logicalRec, rec, oldt);
    }

    @Override
    public Rectangle2D getAnchor() {
        return this.anchor;
    }

    @Override
    public Paint getFillColor() {
        return null;
    }

    @Override
    public float getRotation() {
        return (float)this.xfrm.getRot() / 60000.0f;
    }

    @Override
    public boolean isBackgroundShape() {
        return false;
    }

    @Override
    public boolean isHFlipped() {
        return false;
    }

    @Override
    public boolean isVFlipped() {
        return false;
    }
}

