/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IBackground;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.model.ISlide;
import com.benryan.pptx.SecureXmlUtils;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.PlaceholderCoordinates;
import com.benryan.pptx.record.SlideLayout;
import com.benryan.pptx.record.SlideMaster;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLShape;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.SldDocument;
import org.xml.sax.SAXException;

public class XMLSlide
extends AbstractSlideModel
implements ISlide {
    protected CTSlide ctSlide;
    SlideLayout layout;
    SlideMaster master;

    public XMLSlide(XMLSlideShow slideShow, PackagePart slidePart, SlideLayout layout, SlideMaster master, Theme theme, ColorScheme colorScheme) throws IOException, XmlException, InvalidFormatException, SAXException, ParserConfigurationException {
        super(slideShow, slidePart, theme, colorScheme);
        SldDocument slideDoc = SldDocument.Factory.parse((InputStream)slidePart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        this.ctSlide = slideDoc.getSld();
        this.master = master;
        this.layout = layout;
    }

    @Override
    void acceptShape(IShape shape) {
    }

    @Override
    public boolean getFollowMasterBackground() {
        return false;
    }

    @Override
    public boolean getFollowMasterObjects() {
        boolean showMasterShapes = true;
        if (this.ctSlide.isSetShowMasterSp()) {
            showMasterShapes = this.ctSlide.getShowMasterSp();
        }
        return showMasterShapes;
    }

    @Override
    public IBackground getMasterBackground() {
        return null;
    }

    @Override
    public IShape[] getMasterShapes() {
        return this.layout.getShapes();
    }

    @Override
    public boolean shouldShow() {
        boolean shouldShow = true;
        if (this.ctSlide.isSetShow()) {
            shouldShow = this.ctSlide.getShow();
        }
        return shouldShow;
    }

    @Override
    CTCommonSlideData getCommonSlideData() {
        return this.ctSlide.getCSld();
    }

    @Override
    public AbstractSlideModel getParent() {
        return this.layout;
    }

    @Override
    public XMLShape getPlaceholder(PlaceholderCoordinates coordinates) {
        return null;
    }

    @Override
    SlideMaster getSlideMaster() {
        return this.master;
    }
}

