/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IShape;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.PlaceholderCoordinates;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

public abstract class XMLShape
implements IShape {
    protected XMLSlideShow slideShow;
    protected XMLShape placeholder;
    protected AbstractSlideModel slide;
    protected PlaceholderCoordinates coordinates;

    public XMLShape(XMLSlideShow slideshow, AbstractSlideModel slide, CTApplicationNonVisualDrawingProps nvPr) {
        CTPlaceholder ph;
        this.slideShow = slideshow;
        this.slide = slide;
        if (nvPr != null && (ph = nvPr.getPh()) != null) {
            long phIdx = 0L;
            STPlaceholderType.Enum phType = null;
            if (ph.isSetIdx()) {
                phIdx = ph.getIdx();
            }
            if (ph.isSetType()) {
                phType = ph.getType();
            }
            this.coordinates = new PlaceholderCoordinates(phIdx, phType);
            this.initPlaceholderShape();
            for (XMLShape myPlaceholder = this.placeholder; myPlaceholder != null && phType == null; myPlaceholder = myPlaceholder.getPlaceholderShape()) {
                phType = myPlaceholder.getPhType();
                if (phType == null) continue;
                this.coordinates.setType(phType);
                break;
            }
        }
    }

    @Override
    public abstract Rectangle2D.Double getAnchor();

    @Override
    public abstract float getRotation();

    public STPlaceholderType.Enum getPhType() {
        return this.coordinates != null ? this.coordinates.getType() : null;
    }

    @Override
    public boolean isBackgroundShape() {
        return false;
    }

    @Override
    public abstract boolean isHFlipped();

    @Override
    public abstract boolean isVFlipped();

    @Override
    public Paint getFillColor() {
        CTShapeStyle style;
        if (this.hasNoFill()) {
            return null;
        }
        XmlObject solidFill = this.getFillFromShape();
        if (solidFill == null && (style = this.getStyle()) != null) {
            CTStyleMatrixReference fillRef = style.getFillRef();
            Color fill = ColorScheme.resolveColor((XmlObject)fillRef, this.slide.getColorScheme());
            if (fill == null) {
                long idx = fillRef.getIdx();
                if (idx != 0L) {
                    XmlObject fillStyle = this.slide.getTheme().getFillStyle((int)idx - 1);
                    if (fillStyle instanceof CTGradientFillProperties) {
                        CTGradientFillProperties gradientFill = (CTGradientFillProperties)fillStyle;
                        CTGradientStopList gsLst = gradientFill.getGsLst();
                        solidFill = gsLst.getGsArray(0);
                    } else if (fillStyle instanceof CTSolidColorFillProperties) {
                        solidFill = (CTSolidColorFillProperties)fillStyle;
                    }
                }
            } else if (fillRef.getIdx() != 0L) {
                return fill;
            }
        }
        return ColorScheme.resolveColor(solidFill, this.slide.getColorScheme());
    }

    protected boolean hasNoFill() {
        return false;
    }

    protected abstract XmlObject getFillFromShape();

    protected abstract CTShapeStyle getStyle();

    public PlaceholderCoordinates getCoordinates() {
        return this.coordinates;
    }

    private void initPlaceholderShape() {
        PlaceholderCoordinates coordinates = this.getCoordinates();
        if (coordinates != null) {
            for (AbstractSlideModel current = this.slide.getParent(); current != null; current = current.getParent()) {
                this.placeholder = current.getPlaceholder(coordinates);
                if (this.placeholder != null) break;
            }
        }
    }

    protected XMLShape getPlaceholderShape() {
        return this.placeholder;
    }

    protected CTLineProperties getCTLineProps() {
        CTLineProperties lineProps = this.getLineFromShape();
        if (lineProps == null && this.coordinates != null) {
            XMLShape placeholder;
            for (AbstractSlideModel current = this.slide.getParent(); current != null && ((placeholder = current.getPlaceholder(this.coordinates)) == null || (lineProps = placeholder.getCTLineProps()) == null); current = current.getParent()) {
            }
        }
        return lineProps;
    }

    protected abstract CTLineProperties getLineFromShape();

    @Override
    public AffineTransform createAutoShapeTransform(Rectangle2D logicalRec, Rectangle2D rec, AffineTransform oldt) {
        return XMLShape.createTransform(this, logicalRec, rec, oldt);
    }

    static AffineTransform createTransform(IShape shape, Rectangle2D logicalRec, Rectangle2D rec, AffineTransform oldt) {
        AffineTransform newt = new AffineTransform(oldt);
        float rotation = shape.getRotation();
        if (rotation < 0.0f) {
            rotation = 360.0f - (0.0f - rotation);
        }
        newt.translate(rec.getX(), rec.getY());
        if (shape.isHFlipped()) {
            newt.translate(rec.getWidth(), 0.0);
            newt.scale(-1.0, 1.0);
            rotation = 360.0f - rotation;
        }
        if (shape.isVFlipped()) {
            newt.translate(0.0, rec.getHeight());
            newt.scale(1.0, -1.0);
            rotation = 360.0f - rotation;
        }
        if (rotation != 0.0f) {
            double radians = Math.toRadians(rotation);
            newt.translate(rec.getWidth() / 2.0, rec.getHeight() / 2.0);
            newt.rotate(radians);
            newt.translate(0.0 - rec.getWidth() / 2.0, 0.0 - rec.getHeight() / 2.0);
        }
        if (rec != logicalRec) {
            newt.scale(rec.getWidth() / logicalRec.getWidth(), rec.getHeight() / logicalRec.getHeight());
        }
        newt.translate(0.0 - logicalRec.getX(), 0.0 - logicalRec.getY());
        return newt;
    }
}

