/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IPictureData;
import com.benryan.util.SizeLimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.opc.PackagePart;

public class XMLPictureData
implements IPictureData {
    private static final int MAX_BYTES_THRESHOLD = 0xA00000;
    private final byte[] data;
    private final int type;

    public static XMLPictureData createFrom(PackagePart part) {
        try {
            String contentType = part.getContentType();
            SizeLimitedInputStream limitedInputStream = new SizeLimitedInputStream(part.getInputStream(), 0xA00000);
            byte[] buf = IOUtils.toByteArray((InputStream)limitedInputStream);
            return new XMLPictureData(buf, contentType);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLPictureData(byte[] data, String contentType) {
        this.data = data;
        if (contentType.equalsIgnoreCase("image/png")) {
            this.type = 6;
        } else if (contentType.equalsIgnoreCase("image/jpeg")) {
            this.type = 5;
        } else if (contentType.equalsIgnoreCase("image/x-wmf")) {
            this.type = 3;
        } else if (contentType.equalsIgnoreCase("image/x-emf")) {
            this.type = 2;
        } else if (contentType.equalsIgnoreCase("image/gif")) {
            this.type = 10001;
        } else {
            throw new IllegalArgumentException("Invalid content type: " + contentType);
        }
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

