/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IPicture;
import com.benryan.ppt.api.IPictureData;
import com.benryan.ppt.api.util.ImageOptions;
import com.benryan.pptx.XMLImageOptions;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSingleShape;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.XMLPictureData;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLPicture
extends AbstractSingleShape
implements IPicture {
    private final CTPicture picture;
    private final Logger log = LoggerFactory.getLogger(XMLPicture.class);

    public XMLPicture(XMLSlideShow slideShow, AbstractSlideModel slide, CTPicture picture) {
        super(slideShow, slide, picture.getNvPicPr().getNvPr());
        this.picture = picture;
    }

    @Override
    public IPictureData getPictureData() {
        XMLPictureData pictureData = null;
        try {
            CTBlipFillProperties props = this.picture.getBlipFill();
            CTBlip blip = props.getBlip();
            PackageRelationship pr = this.slide.getPackagePart().getRelationship(blip.getEmbed());
            PackagePart part = this.getTargetPart(pr);
            pictureData = XMLPictureData.createFrom(part);
        }
        catch (Exception e) {
            this.log.warn("Error whilst reading image data; skipping the image: {}", (Object)e.getMessage());
        }
        return pictureData;
    }

    private PackagePart getTargetPart(PackageRelationship pr) {
        try {
            return this.slideShow.getTargetPart(pr);
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImageOptions getImageOptions() {
        return new XMLImageOptions(this.picture.getBlipFill());
    }

    @Override
    protected CTShapeStyle getStyle() {
        return this.picture.getStyle();
    }

    @Override
    public CTShapeProperties getShapeProperties() {
        return this.picture.getSpPr();
    }
}

