/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.PptRenderer;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.BulletStyle;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLCharacterStyle;
import java.awt.Color;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacingPercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacingPoint;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;

public class XMLParagraphStyle
implements Cloneable {
    private BulletStyle bulletStyle;
    private XMLCharacterStyle textProps;
    private double lineSpacing = 100.0;
    private double spaceAfter;
    private double spaceBefore;
    private double indent = 0.0;
    private double leftMargin = 0.0;
    private double rightMargin;
    private STTextAlignType.Enum alignment;

    public XMLParagraphStyle(CTTextParagraphProperties props, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        this.initProps(props, mainPart, slideShow, theme, colorScheme);
    }

    public XMLParagraphStyle(XMLParagraphStyle defaults) {
        try {
            this.bulletStyle = (BulletStyle)defaults.bulletStyle.clone();
            if (defaults.textProps != null) {
                this.textProps = (XMLCharacterStyle)defaults.textProps.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.lineSpacing = defaults.lineSpacing;
        this.spaceAfter = defaults.spaceAfter;
        this.spaceBefore = defaults.spaceBefore;
        this.indent = defaults.indent;
        this.leftMargin = defaults.leftMargin;
        this.rightMargin = defaults.rightMargin;
        this.alignment = defaults.alignment;
    }

    public XMLParagraphStyle() {
        this.bulletStyle = new BulletStyle();
        this.textProps = new XMLCharacterStyle();
    }

    void initProps(CTTextParagraphProperties props, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        CTTextCharacterProperties defRPr;
        STTextAlignType.Enum algn;
        CTTextSpacing spcAft;
        CTTextSpacing spcBef;
        double spacing;
        if (this.bulletStyle == null) {
            this.bulletStyle = new BulletStyle(props, colorScheme);
        } else {
            this.bulletStyle.initProps(props, colorScheme);
        }
        CTTextSpacing lnSpc = props.getLnSpc();
        if (lnSpc != null) {
            CTTextSpacingPercent spcPct = lnSpc.getSpcPct();
            CTTextSpacingPoint spcPts = lnSpc.getSpcPts();
            this.lineSpacing = spacing = this.normalizeSize(spcPct, spcPts);
        }
        if ((spcBef = props.getSpcBef()) != null) {
            double spacing2;
            this.spaceBefore = spacing2 = this.normalizeSize(spcBef.getSpcPct(), spcBef.getSpcPts());
        }
        if ((spcAft = props.getSpcAft()) != null) {
            this.spaceAfter = spacing = this.normalizeSize(spcAft.getSpcPct(), spcAft.getSpcPts());
        }
        if ((algn = props.getAlgn()) != null) {
            this.alignment = algn;
        }
        if (props.isSetIndent()) {
            this.indent = this.convertToPixels(props.getIndent());
        }
        if (props.isSetMarL()) {
            this.leftMargin = this.convertToPixels(props.getMarL());
        }
        if (props.isSetMarR()) {
            this.rightMargin = this.convertToPixels(props.getMarR());
        }
        if ((defRPr = props.getDefRPr()) != null) {
            if (this.textProps == null) {
                this.textProps = new XMLCharacterStyle(defRPr, mainPart, slideShow, theme, colorScheme);
            } else {
                this.textProps.initProps(defRPr, mainPart, slideShow, theme, colorScheme);
            }
        }
    }

    private double convertToPixels(int val) {
        return (double)val / 9525.0;
    }

    private double normalizeSize(CTTextSpacingPercent spcPct, CTTextSpacingPoint spcPts) {
        double spacing = 0.0;
        if (spcPts != null) {
            spacing = -((double)spcPts.getVal()) / 100.0 * PptRenderer.POINTS_TO_PIXELS;
        } else if (spcPct != null) {
            spacing = (double)spcPct.getVal() / 1000.0;
        }
        return spacing;
    }

    public int getBulletOffset() {
        return (int)this.indent + (int)this.leftMargin;
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public double getSpaceAfter() {
        return this.spaceAfter;
    }

    public int getAlignment() {
        return this.alignment != null ? this.alignment.intValue() - 1 : 0;
    }

    public String getBulletFontName() {
        return this.bulletStyle.getBulletFontName();
    }

    public boolean isBullet() {
        return this.bulletStyle.hasBullet();
    }

    public int getTextOffset() {
        return (int)this.leftMargin;
    }

    public Color getBulletColor() {
        return this.bulletStyle.getBulletColor();
    }

    public double getBulletSize() {
        return this.bulletStyle.getBulletSize();
    }

    public double getSpaceBefore() {
        return this.spaceBefore;
    }

    public char getBulletChar() {
        return this.bulletStyle.getBulletChar();
    }

    public XMLCharacterStyle getTextProps() {
        return this.textProps;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setFont(String fontName, Color color) {
        this.textProps.setFont(fontName, color);
    }
}

