/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.usermodel.Paragraph;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.EmptyTextRun;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLCharacterStyle;
import com.benryan.pptx.record.XMLParagraphStyle;
import com.benryan.pptx.record.XMLTextRun;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;

public class XMLParagraphFactory {
    private ArrayList runList = new ArrayList();
    private ArrayList<Paragraph> paragraphList = new ArrayList();
    private XMLParagraphStyle paragraphStyle;
    private int currentTextOffset;

    private XMLParagraphFactory() {
    }

    public static List<? extends Paragraph> createParagraphs(XMLParagraphStyle defaultStyle, CTTextParagraph paragraphElement, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme, CTTextBodyProperties bodyPr, CTTextListStyle lstStyle) {
        XMLParagraphFactory paragraphFactory = new XMLParagraphFactory();
        paragraphFactory.paragraphStyle = defaultStyle != null ? new XMLParagraphStyle(defaultStyle) : new XMLParagraphStyle();
        return paragraphFactory.createParagraphsInternal(paragraphElement, mainPart, slideShow, theme, colorScheme, bodyPr, lstStyle);
    }

    private List<? extends Paragraph> createParagraphsInternal(CTTextParagraph paragraphElement, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme, CTTextBodyProperties bodyPr, CTTextListStyle lstStyle) {
        XmlObject[] elements;
        for (XmlObject element : elements = paragraphElement.selectChildren(QNameSet.ALL)) {
            this.addXmlObject(element, mainPart, slideShow, theme, colorScheme);
        }
        XMLCharacterStyle breakStyle = null;
        CTTextCharacterProperties rPr = paragraphElement.getEndParaRPr();
        if (rPr != null) {
            breakStyle = new XMLCharacterStyle(this.paragraphStyle.getTextProps());
            breakStyle.initProps(rPr, mainPart, slideShow, theme, colorScheme);
        }
        this.endParagraph(false, breakStyle, mainPart, slideShow, theme, colorScheme);
        return this.paragraphList;
    }

    private void addXmlObject(XmlObject xmlObject, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        if (xmlObject instanceof CTTextLineBreak) {
            this.addLineBreak((CTTextLineBreak)xmlObject, mainPart, slideShow, theme, colorScheme);
        } else if (xmlObject instanceof CTTextField) {
            this.addTextField((CTTextField)xmlObject, mainPart, slideShow, theme, colorScheme);
        } else if (xmlObject instanceof CTTextParagraphProperties) {
            this.setTextParagraphProperties((CTTextParagraphProperties)xmlObject, mainPart, slideShow, theme, colorScheme);
        } else if (xmlObject instanceof CTRegularTextRun) {
            this.addTextRun((CTRegularTextRun)xmlObject, mainPart, slideShow, theme, colorScheme);
        }
    }

    private void addTextRun(CTRegularTextRun ctRegularTextRun, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        String text = ctRegularTextRun.getT();
        if (text.length() > 0) {
            this.runList.add(new XMLTextRun(this.currentTextOffset, this.paragraphStyle, ctRegularTextRun.getRPr(), text, mainPart, slideShow, theme, colorScheme));
            this.currentTextOffset += text.length();
        }
    }

    private void setTextParagraphProperties(CTTextParagraphProperties paragraphProps, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        if (this.paragraphStyle == null) {
            this.paragraphStyle = new XMLParagraphStyle(paragraphProps, mainPart, slideShow, theme, colorScheme);
        } else {
            this.paragraphStyle.initProps(paragraphProps, mainPart, slideShow, theme, colorScheme);
        }
    }

    private void addTextField(CTTextField ctTextField, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        String text = ctTextField.getT();
        this.runList.add(new XMLTextRun(this.currentTextOffset, this.paragraphStyle, ctTextField.getRPr(), text, mainPart, slideShow, theme, colorScheme));
        this.currentTextOffset += text.length();
    }

    private void addLineBreak(CTTextLineBreak ctTextLineBreak, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        XMLCharacterStyle softBreakStyle = null;
        CTTextCharacterProperties rPr = ctTextLineBreak.getRPr();
        if (rPr != null) {
            softBreakStyle = new XMLCharacterStyle(this.paragraphStyle.getTextProps());
            softBreakStyle.initProps(rPr, mainPart, slideShow, theme, colorScheme);
        }
        this.endParagraph(true, softBreakStyle, mainPart, slideShow, theme, colorScheme);
        this.runList = new ArrayList();
    }

    private void endParagraph(boolean softBreak, XMLCharacterStyle breakStyle, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        if (this.runList.isEmpty()) {
            this.runList.add(new EmptyTextRun(this.paragraphStyle, breakStyle));
        }
        this.paragraphList.add(new Paragraph(this.runList, softBreak));
    }
}

