/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.escher.api.usermodel.IShapeGroup;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.Transformer;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.XMLShape;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;

public class XMLGroupShape
extends XMLShape
implements IShapeGroup {
    private final CTGroupShape groupShape;
    private final List<IShape> children;

    public XMLGroupShape(XMLSlideShow slideShow, AbstractSlideModel slide, CTGroupShape groupShape, List<IShape> children) {
        super(slideShow, slide, groupShape.getNvGrpSpPr().getNvPr());
        this.groupShape = groupShape;
        this.children = children;
    }

    @Override
    protected CTShapeStyle getStyle() {
        return null;
    }

    @Override
    protected XmlObject getFillFromShape() {
        return this.groupShape.getGrpSpPr().getSolidFill();
    }

    @Override
    protected CTLineProperties getLineFromShape() {
        return null;
    }

    @Override
    public Rectangle2D.Double getAnchor() {
        CTGroupTransform2D transform2d = this.getTransform2D();
        CTPoint2D offset = transform2d.getOff();
        CTPositiveSize2D extent = transform2d.getExt();
        Rectangle anchor = new Rectangle((int)offset.getX(), (int)offset.getY(), (int)extent.getCx(), (int)extent.getCy());
        return Transformer.transformRectangle(anchor);
    }

    @Override
    public float getRotation() {
        return (float)this.getTransform2D().getRot() / 60000.0f;
    }

    @Override
    public boolean isHFlipped() {
        return false;
    }

    @Override
    public boolean isVFlipped() {
        return false;
    }

    private CTGroupTransform2D getTransform2D() {
        return this.groupShape.getGrpSpPr().getXfrm();
    }

    @Override
    public IShape[] getShapes() {
        return this.children.toArray(new IShape[this.children.size()]);
    }

    @Override
    public Rectangle2D.Double getTransformedAnchor() {
        CTGroupTransform2D transform2d = this.getTransform2D();
        CTPoint2D offset = transform2d.getChOff();
        CTPositiveSize2D extent = transform2d.getChExt();
        Rectangle anchor = new Rectangle((int)offset.getX(), (int)offset.getY(), (int)extent.getCx(), (int)extent.getCy());
        return Transformer.transformRectangle(anchor);
    }

    @Override
    public AffineTransform getChildTransform(AffineTransform anchorTransform) {
        Rectangle2D.Double rec = this.getTransformedAnchor();
        Rectangle2D.Double rec1 = this.getAnchor();
        double scaleX = rec1.getWidth() / rec.getWidth();
        double scaleY = rec1.getHeight() / rec.getHeight();
        AffineTransform oldTransform = new AffineTransform();
        if (anchorTransform != null) {
            oldTransform = anchorTransform;
        }
        AffineTransform newTransform = new AffineTransform(oldTransform);
        newTransform.scale(scaleX, scaleY);
        newTransform.translate(0.0 - rec.getX(), 0.0 - rec.getY());
        newTransform.translate(rec1.getX() / scaleX, rec1.getY() / scaleY);
        return newTransform;
    }
}

