/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.FillProperties;
import com.benryan.pptx.record.Theme;
import java.awt.Color;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontCollection;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyleTextStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.STFontCollectionIndex;
import org.openxmlformats.schemas.drawingml.x2006.main.STOnOffStyleType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;

public class XMLCharacterStyle
implements Cloneable {
    FillProperties fill;
    boolean bold;
    boolean italic;
    double fontSize = 18.0;
    STTextUnderlineType.Enum underline;
    String fontName;

    public XMLCharacterStyle(CTTextCharacterProperties props, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        this.initProps(props, mainPart, slideShow, theme, colorScheme);
    }

    public XMLCharacterStyle() {
        this.fill = new FillProperties();
    }

    public XMLCharacterStyle(CTTableStyleTextStyle props, AbstractSlideModel slide) {
        this.initPropsFromTable(props, slide);
    }

    public void initPropsFromTable(CTTableStyleTextStyle props, AbstractSlideModel slide) {
        CTTextFont latin;
        STFontCollectionIndex.Enum idx;
        STOnOffStyleType.Enum i;
        STOnOffStyleType.Enum b;
        Color fillColor;
        if (this.fill == null) {
            this.fill = new FillProperties();
        }
        if ((fillColor = ColorScheme.resolveColor((XmlObject)props, slide.getColorScheme())) != null) {
            this.fill.setColor(fillColor);
        }
        if ((b = props.getB()) != null) {
            this.bold = b.equals(STOnOffStyleType.ON);
        }
        if ((i = props.getI()) != null) {
            this.italic = i.equals(STOnOffStyleType.ON);
        }
        CTFontCollection font = props.getFont();
        CTFontReference fontRef = props.getFontRef();
        if (fontRef != null && (idx = fontRef.getIdx()) != null) {
            if (idx.equals(STFontCollectionIndex.MAJOR)) {
                this.setFont(slide.getTheme().getMajorLatinTypeface(), ColorScheme.resolveColor((XmlObject)fontRef, slide.getColorScheme()));
            } else if (idx.equals(STFontCollectionIndex.MINOR)) {
                this.setFont(slide.getTheme().getMinorLatinTypeface(), ColorScheme.resolveColor((XmlObject)fontRef, slide.getColorScheme()));
            }
        }
        if (font != null && (latin = font.getLatin()) != null) {
            this.fontName = latin.getTypeface();
            if (this.fontName.equals("+mj-lt")) {
                this.fontName = slide.getTheme().getMajorLatinTypeface();
            } else if (this.fontName.equals("+mn-lt")) {
                this.fontName = slide.getTheme().getMinorLatinTypeface();
            }
        }
    }

    public XMLCharacterStyle(XMLCharacterStyle textProps) {
        this.bold = textProps.bold;
        this.italic = textProps.italic;
        this.fontSize = textProps.fontSize;
        this.underline = textProps.underline;
        this.fontName = textProps.fontName;
        this.fill = (FillProperties)textProps.fill.clone();
    }

    void initProps(CTTextCharacterProperties props, PackagePart mainPart, XMLSlideShow slideShow, Theme theme, ColorScheme colorScheme) {
        CTTextFont latin;
        try {
            if (this.fill == null) {
                this.fill = new FillProperties((XmlObject)props, mainPart, slideShow, colorScheme);
            } else {
                this.fill.initProps((XmlObject)props, mainPart, slideShow, colorScheme);
            }
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        this.bold = props.getB();
        this.italic = props.getI();
        this.underline = props.getU();
        if (props.isSetSz()) {
            this.fontSize = (double)props.getSz() / 100.0;
        }
        if ((latin = props.getLatin()) != null) {
            this.fontName = latin.getTypeface();
            if (this.fontName.equals("+mj-lt")) {
                this.fontName = theme.getMajorLatinTypeface();
            } else if (this.fontName.equals("+mn-lt")) {
                this.fontName = theme.getMinorLatinTypeface();
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        ((XMLCharacterStyle)clone).fill = (FillProperties)this.fill.clone();
        return clone;
    }

    public FillProperties getFill() {
        return this.fill;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public STTextUnderlineType.Enum getUnderline() {
        return this.underline;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isUnderlined() {
        return this.underline != null && this.underline.intValue() != 1;
    }

    public void setFont(String fontName, Color color) {
        this.fontName = fontName;
        this.fill.setColor(color);
    }
}

