/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.CellType;
import com.benryan.pptx.record.XMLTableCellStyle;
import com.benryan.pptx.record.XMLTableStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableProperties;

public class XMLCellStyleFinder {
    private CTTableProperties tblPr;
    private XMLTableStyle style;
    private AbstractSlideModel slide;
    private boolean useFirstRow;
    private boolean useLastRow;
    private boolean useFirstCol;
    private boolean useLastCol;
    private boolean useHBand;
    private boolean useVBand;

    public XMLCellStyleFinder(CTTableProperties tblPr, XMLTableStyle style, AbstractSlideModel slide) {
        this.tblPr = tblPr;
        this.style = style;
        this.slide = slide;
        this.useFirstRow = tblPr.isSetFirstRow() && tblPr.getFirstRow();
        this.useLastRow = tblPr.isSetLastRow() && tblPr.getLastRow();
        this.useFirstCol = tblPr.isSetFirstCol() && tblPr.getFirstCol();
        this.useLastCol = tblPr.isSetLastCol() && tblPr.getLastCol();
        this.useHBand = tblPr.isSetBandRow() && tblPr.getBandRow();
        this.useVBand = tblPr.isSetBandCol() && tblPr.getBandCol();
    }

    public XMLTableCellStyle findStyle(int row, int col, int numRows, int numCols) {
        XMLTableCellStyle cellStyle = null;
        if (this.style != null) {
            if (this.useFirstRow && row == 0) {
                cellStyle = this.style.getCellStyle(CellType.FIRST_ROW, this.slide);
            } else if (this.useFirstCol && col == 0) {
                cellStyle = this.style.getCellStyle(CellType.FIRST_COL, this.slide);
            } else if (this.useLastRow && row == numRows - 1) {
                cellStyle = this.style.getCellStyle(CellType.LAST_ROW, this.slide);
            } else if (this.useLastCol && col == numCols - 1) {
                cellStyle = this.style.getCellStyle(CellType.LAST_COL, this.slide);
            } else if (this.useHBand) {
                cellStyle = row % 2 == 0 || this.useFirstRow && row % 2 == 1 ? this.style.getCellStyle(CellType.HBAND1, this.slide) : this.style.getCellStyle(CellType.HBAND2, this.slide);
            }
            if (this.useVBand) {
                cellStyle = col % 2 == 0 || this.useFirstCol && col % 2 == 1 ? this.style.getCellStyle(CellType.VBAND1, this.slide) : this.style.getCellStyle(CellType.VBAND2, this.slide);
            }
            if (cellStyle == null) {
                cellStyle = this.style.getCellStyle(CellType.DEFAULT, this.slide);
            }
        }
        return cellStyle;
    }
}

