/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.usermodel.Paragraph;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSingleShape;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.LineProperties;
import com.benryan.pptx.record.XMLParagraphFactory;
import com.benryan.pptx.record.XMLParagraphStyle;
import com.benryan.pptx.record.XMLShape;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STFontCollectionIndex;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

public class XMLAutoShape
extends AbstractSingleShape
implements IAutoShape,
EscherHostTextContainer,
ITextBox {
    private int bottomMargin = 4;
    private int topMargin = 4;
    private int leftMargin = 9;
    private int rightMargin = 9;
    private int vertAlign = 0;
    private int wordWrap = 0;
    private CTShape shape;
    private LineProperties lineProperties;

    public XMLAutoShape(XMLSlideShow slideshow, AbstractSlideModel slide, CTShape shape) {
        super(slideshow, slide, shape.getNvSpPr().getNvPr());
        this.shape = shape;
        this.lineProperties = this.getLineProperties();
    }

    @Override
    public Color getLineColor() {
        return this.lineProperties.getColor();
    }

    @Override
    public double getLineWidth() {
        return this.lineProperties.getWidth();
    }

    public CTShape getCTShape() {
        return this.shape;
    }

    @Override
    protected CTShapeStyle getStyle() {
        return this.shape.getStyle();
    }

    @Override
    public List<Paragraph> getParagraphs() {
        CTTextListStyle lstStyle;
        CTTextBody textBody = this.shape.getTxBody();
        if (textBody == null) {
            return Collections.emptyList();
        }
        XMLShape phShape1 = this.getPlaceholderShape();
        XMLShape phShape2 = phShape1 != null ? phShape1.getPlaceholderShape() : null;
        STPlaceholderType.Enum phType = null;
        if (phShape2 != null) {
            phType = phShape2.getPhType();
        } else if (phShape1 != null) {
            phType = phShape1.getPhType();
        }
        if (phType == null) {
            phType = this.getPhType();
        }
        Map<Integer, XMLParagraphStyle> defaultStyles = null;
        defaultStyles = phType != null ? this.slide.getSlideMaster().getStyleMap(phType) : this.slide.getSlideMaster().getDefaultStyles();
        this.applyBodyPropsFromPlaceholder(phShape2, defaultStyles);
        this.applyBodyPropsFromPlaceholder(phShape1, defaultStyles);
        CTTextBodyProperties bodyPr = textBody.getBodyPr();
        if (bodyPr != null) {
            this.loadBodyProps(bodyPr);
        }
        if ((lstStyle = textBody.getLstStyle()) != null && !lstStyle.isNil()) {
            this.slide.loadListLevels(lstStyle, defaultStyles, defaultStyles);
        }
        CTFontReference fontRef = null;
        CTShapeStyle style = this.shape.getStyle();
        if (style != null) {
            fontRef = style.getFontRef();
        }
        ArrayList<Paragraph> rv = new ArrayList<Paragraph>();
        for (CTTextParagraph paragraphElement : textBody.getPArray()) {
            STFontCollectionIndex.Enum idx;
            XMLParagraphStyle defaultStyle = null;
            CTTextParagraphProperties pPr = paragraphElement.getPPr();
            int lvl = 0;
            if (pPr != null && pPr.isSetLvl()) {
                lvl = pPr.getLvl();
            }
            defaultStyle = defaultStyles.get(lvl);
            if (fontRef != null && (idx = fontRef.getIdx()) != null) {
                defaultStyle = new XMLParagraphStyle(defaultStyle);
                if (idx.equals(STFontCollectionIndex.MAJOR)) {
                    defaultStyle.setFont(this.slide.getTheme().getMajorLatinTypeface(), ColorScheme.resolveColor((XmlObject)fontRef, this.slide.getColorScheme()));
                } else if (idx.equals(STFontCollectionIndex.MINOR)) {
                    defaultStyle.setFont(this.slide.getTheme().getMinorLatinTypeface(), ColorScheme.resolveColor((XmlObject)fontRef, this.slide.getColorScheme()));
                }
            }
            rv.addAll(this.createParagraphs(defaultStyle, paragraphElement, textBody.getBodyPr(), textBody.getLstStyle()));
        }
        return rv;
    }

    private void applyBodyPropsFromPlaceholder(XMLShape phShape2, Map<Integer, XMLParagraphStyle> defaultStyles) {
        if (phShape2 != null && phShape2 instanceof XMLAutoShape) {
            XMLAutoShape placeholderShape = (XMLAutoShape)phShape2;
            CTTextBody parentTextBody = placeholderShape.shape.getTxBody();
            if (parentTextBody != null) {
                CTTextBodyProperties bodyPr = parentTextBody.getBodyPr();
                this.loadBodyProps(bodyPr);
                CTTextListStyle lstStyle = parentTextBody.getLstStyle();
                if (lstStyle != null) {
                    this.slide.loadListLevels(lstStyle, defaultStyles, defaultStyles);
                }
            }
        }
    }

    private void loadBodyProps(CTTextBodyProperties bodyPr) {
        if (bodyPr == null) {
            return;
        }
        if (bodyPr.isSetAnchor()) {
            STTextAnchoringType.Enum anchor = bodyPr.getAnchor();
            this.vertAlign = anchor == STTextAnchoringType.B ? 2 : (anchor == STTextAnchoringType.CTR ? 1 : 0);
        }
        if (bodyPr.isSetTIns()) {
            this.topMargin = bodyPr.getTIns() / 9525;
        }
        if (bodyPr.isSetBIns()) {
            this.bottomMargin = bodyPr.getBIns() / 9525;
        }
        if (bodyPr.isSetRIns()) {
            this.rightMargin = bodyPr.getRIns() / 9525;
        }
        if (bodyPr.isSetLIns()) {
            this.leftMargin = bodyPr.getLIns() / 9525;
        }
        if (bodyPr.isSetWrap() && bodyPr.getWrap() == STTextWrappingType.NONE) {
            this.wordWrap = 2;
        }
    }

    private List<? extends Paragraph> createParagraphs(XMLParagraphStyle defaultStyle, CTTextParagraph paragraphElement, CTTextBodyProperties bodyPr, CTTextListStyle lstStyle) {
        return XMLParagraphFactory.createParagraphs(defaultStyle, paragraphElement, this.slide.getPackagePart(), this.slide.getSlideShow(), this.slide.getTheme(), this.slide.getColorScheme(), bodyPr, lstStyle);
    }

    @Override
    public int getDefaultVertAlign() {
        return 0;
    }

    @Override
    public int getMarginBottom() {
        return this.bottomMargin;
    }

    @Override
    public int getMarginLeft() {
        return this.leftMargin;
    }

    @Override
    public int getMarginRight() {
        return this.rightMargin;
    }

    @Override
    public int getMarginTop() {
        return this.topMargin;
    }

    @Override
    public Rectangle2D getTextRectangle(Rectangle2D anchor) {
        CTGeomRect rect;
        CTCustomGeometry2D custGeom = this.getShapeProperties().getCustGeom();
        if (custGeom != null && (rect = custGeom.getRect()) != null) {
            try {
                Object obj = rect.getL();
                double left = this.getTextRectCoordinate(obj.toString(), anchor);
                obj = rect.getR();
                double right = this.getTextRectCoordinate(obj.toString(), anchor);
                obj = rect.getT();
                double top = this.getTextRectCoordinate(obj.toString(), anchor);
                obj = rect.getB();
                double bottom = this.getTextRectCoordinate(obj.toString(), anchor);
                return new Rectangle2D.Double(left, top, right - left, top - bottom);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private double getTextRectCoordinate(String val, Rectangle2D rec) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return this.processKnownVars(val, rec);
        }
    }

    @Override
    public int getVerticalAlignment() {
        return this.vertAlign;
    }

    @Override
    public int getWordWrap() {
        return this.wordWrap;
    }

    @Override
    public boolean shouldRender(boolean isMaster) {
        return !isMaster || this.coordinates == null;
    }

    private double processKnownVars(String var, Rectangle2D anchor) {
        if (var.equals("h")) {
            return anchor.getHeight();
        }
        if (var.equals("w")) {
            return anchor.getWidth();
        }
        if (var.equals("l")) {
            return anchor.getX();
        }
        if (var.equals("t")) {
            return anchor.getY();
        }
        if (var.equals("r")) {
            return anchor.getX() + anchor.getWidth();
        }
        if (var.equals("b")) {
            return anchor.getY() + anchor.getHeight();
        }
        if (var.equals("hc")) {
            return (anchor.getX() + anchor.getWidth()) / 2.0;
        }
        if (var.equals("vc")) {
            return (anchor.getY() + anchor.getHeight()) / 2.0;
        }
        if (var.equals("3cd4")) {
            return 1.62E7;
        }
        if (var.equals("3cd8")) {
            return 8100000.0;
        }
        if (var.equals("5cd8")) {
            return 1.35E7;
        }
        if (var.equals("7cd8")) {
            return 1.89E7;
        }
        if (var.equals("cd2")) {
            return 1.08E7;
        }
        if (var.equals("cd4")) {
            return 5400000.0;
        }
        if (var.equals("cd8")) {
            return 2700000.0;
        }
        if (var.equals("hd2")) {
            return anchor.getHeight() / 2.0;
        }
        if (var.equals("hd4")) {
            return anchor.getHeight() / 4.0;
        }
        if (var.equals("hd5")) {
            return anchor.getHeight() / 5.0;
        }
        if (var.equals("hd6")) {
            return anchor.getHeight() / 6.0;
        }
        if (var.equals("hd8")) {
            return anchor.getHeight() / 8.0;
        }
        if (var.equals("hd3")) {
            return anchor.getHeight() / 3.0;
        }
        if (var.equals("ls")) {
            return Math.max(anchor.getHeight(), anchor.getWidth());
        }
        if (var.equals("ss")) {
            return Math.min(anchor.getHeight(), anchor.getWidth());
        }
        if (var.equals("ssd2")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 2.0;
        }
        if (var.equals("ssd4")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 4.0;
        }
        if (var.equals("ssd6")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 6.0;
        }
        if (var.equals("ssd8")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 8.0;
        }
        if (var.equals("ssd16")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 16.0;
        }
        if (var.equals("ssd32")) {
            return Math.min(anchor.getHeight(), anchor.getWidth()) / 32.0;
        }
        if (var.equals("wd2")) {
            return anchor.getWidth() / 2.0;
        }
        if (var.equals("wd4")) {
            return anchor.getWidth() / 4.0;
        }
        if (var.equals("wd5")) {
            return anchor.getWidth() / 5.0;
        }
        if (var.equals("wd6")) {
            return anchor.getWidth() / 6.0;
        }
        if (var.equals("wd8")) {
            return anchor.getWidth() / 8.0;
        }
        if (var.equals("wd10")) {
            return anchor.getWidth() / 10.0;
        }
        if (var.equals("wd3")) {
            return anchor.getWidth() / 3.0;
        }
        if (var.equals("wd32")) {
            return anchor.getWidth() / 32.0;
        }
        throw new IllegalArgumentException("unknown value " + var);
    }

    @Override
    public boolean isHFlipped() {
        if (this.doesShapeHaveText()) {
            return false;
        }
        return super.isHFlipped();
    }

    @Override
    public boolean doesShapeHaveText() {
        CTTextBody txBody = this.shape.getTxBody();
        if (txBody != null) {
            CTTextParagraph[] pArray;
            for (CTTextParagraph ctTextParagraph : pArray = txBody.getPArray()) {
                CTRegularTextRun[] rArray;
                for (CTRegularTextRun ctRegularTextRun : rArray = ctTextParagraph.getRArray()) {
                    if (ctRegularTextRun.getT().length() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ITextBox getTextBox() {
        return this;
    }

    @Override
    public EscherHostTextContainer getEscherHostTextContainer() {
        return this;
    }

    @Override
    public CTShapeProperties getShapeProperties() {
        return this.shape.getSpPr();
    }
}

