/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.SecureXmlUtils;
import com.benryan.pptx.record.ColorScheme;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBackgroundFillStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFillStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontCollection;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeStyleSheet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.xml.sax.SAXException;

public class Theme {
    private ColorScheme colorScheme;
    private XmlObject[] fillStyles;
    private XmlObject[] bgFillStyles;
    private CTLineProperties[] lnArray;
    private String majorLatinTypeface;
    private String minorLatinTypeface;
    private PackagePart themePart;

    public Theme(PackagePart themePart) throws XmlException, IOException, SAXException, ParserConfigurationException {
        this.themePart = themePart;
        ThemeDocument themeDoc = ThemeDocument.Factory.parse((InputStream)themePart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        CTOfficeStyleSheet theme = themeDoc.getTheme();
        CTBaseStyles themeElements = theme.getThemeElements();
        CTStyleMatrix fmtScheme = themeElements.getFmtScheme();
        CTFillStyleList fillStyleLst = fmtScheme.getFillStyleLst();
        this.fillStyles = fillStyleLst.selectChildren(QNameSet.ALL);
        CTBackgroundFillStyleList bgFillStyleLst = fmtScheme.getBgFillStyleLst();
        this.bgFillStyles = bgFillStyleLst.selectChildren(QNameSet.ALL);
        CTLineStyleList lnStyleLst = fmtScheme.getLnStyleLst();
        this.lnArray = lnStyleLst.getLnArray();
        this.colorScheme = new ColorScheme(themeElements.getClrScheme());
        CTFontScheme fontScheme = themeElements.getFontScheme();
        if (fontScheme != null) {
            CTTextFont latin;
            CTFontCollection minorFont;
            CTTextFont latin2;
            CTFontCollection majorFont = fontScheme.getMajorFont();
            if (majorFont != null && (latin2 = majorFont.getLatin()) != null) {
                this.majorLatinTypeface = latin2.getTypeface();
            }
            if ((minorFont = fontScheme.getMinorFont()) != null && (latin = minorFont.getLatin()) != null) {
                this.minorLatinTypeface = latin.getTypeface();
            }
        }
    }

    public String getMajorLatinTypeface() {
        return this.majorLatinTypeface;
    }

    public String getMinorLatinTypeface() {
        return this.minorLatinTypeface;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public XmlObject getFillStyle(int i) {
        return this.fillStyles[i];
    }

    public XmlObject getBgFillStyle(int i) {
        return this.bgFillStyles[i];
    }

    public CTLineProperties getLineStyle(int i) {
        return this.lnArray[i];
    }

    public PackagePart getPackagePart() {
        return this.themePart;
    }
}

