/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IShape;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractParentSlide;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.PlaceholderCoordinates;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLParagraphStyle;
import com.benryan.pptx.record.XMLShape;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterTextStyles;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;

public class SlideMaster
extends AbstractParentSlide {
    private CTSlideMaster sldMaster;
    HashMap<Integer, XMLParagraphStyle> bodyStyles;
    HashMap<Integer, XMLParagraphStyle> titleStyles;
    HashMap<Integer, XMLParagraphStyle> otherStyles;
    HashMap<Integer, XMLParagraphStyle> defaultPresStyles;
    IShape[] myShapes;

    public SlideMaster(XMLSlideShow slideShow, PackagePart mainPart, SldMasterDocument master, Theme theme, ColorScheme colorScheme) {
        super(slideShow, mainPart, theme, colorScheme);
        this.sldMaster = master.getSldMaster();
        this.bodyStyles = new HashMap();
        this.titleStyles = new HashMap();
        this.otherStyles = new HashMap();
        this.defaultPresStyles = new HashMap();
        CTSlideMasterTextStyles txStyles = this.sldMaster.getTxStyles();
        if (txStyles != null) {
            CTPresentation presentation;
            CTTextListStyle defaultTextStyle;
            CTTextListStyle otherStyle;
            CTTextListStyle titleStyle;
            CTTextListStyle bodyStyle = txStyles.getBodyStyle();
            if (bodyStyle != null) {
                this.loadListLevels(bodyStyle, this.bodyStyles);
            }
            if ((titleStyle = txStyles.getTitleStyle()) != null) {
                this.loadListLevels(titleStyle, this.titleStyles);
            }
            if ((otherStyle = txStyles.getOtherStyle()) != null) {
                this.loadListLevels(otherStyle, this.otherStyles);
            }
            if ((defaultTextStyle = (presentation = slideShow.getPresentation()).getDefaultTextStyle()) != null) {
                this.loadListLevels(defaultTextStyle, this.defaultPresStyles);
            }
        }
        this.myShapes = super.getShapes();
    }

    public XMLParagraphStyle getDefaultStyle(int level) {
        return this.defaultPresStyles.get(level);
    }

    public XMLParagraphStyle getListStyle(String type, int level) {
        if (type.equals("body")) {
            return this.bodyStyles.get(level);
        }
        if (type.toLowerCase().indexOf("title") != -1) {
            return this.titleStyles.get(level);
        }
        return this.otherStyles.get(level);
    }

    @Override
    protected CTCommonSlideData getCommonSlideData() {
        return this.sldMaster.getCSld();
    }

    @Override
    public AbstractSlideModel getParent() {
        return null;
    }

    @Override
    SlideMaster getSlideMaster() {
        return this;
    }

    public Map<Integer, XMLParagraphStyle> getStyleMap(STPlaceholderType.Enum phType) {
        if (phType == null || phType.equals(STPlaceholderType.BODY)) {
            return (Map)this.bodyStyles.clone();
        }
        if (phType.equals(STPlaceholderType.TITLE) || phType.equals(STPlaceholderType.CTR_TITLE) || phType.equals(STPlaceholderType.SUB_TITLE)) {
            return (Map)this.titleStyles.clone();
        }
        return (Map)this.otherStyles.clone();
    }

    @Override
    public IShape[] getShapes() {
        return this.myShapes;
    }

    @Override
    public XMLShape getPlaceholder(PlaceholderCoordinates coordinates) {
        XMLShape xmlShape;
        STPlaceholderType.Enum type;
        XMLShape placeholder = super.getPlaceholder(coordinates);
        if (placeholder == null && (type = coordinates.getType()) != null && type.toString().toLowerCase().indexOf("title") != -1 && (xmlShape = (XMLShape)this.layoutShapesByType.get(STPlaceholderType.TITLE)) != null) {
            return xmlShape;
        }
        return placeholder;
    }

    public Map<Integer, XMLParagraphStyle> getDefaultStyles() {
        return (Map)this.defaultPresStyles.clone();
    }
}

