/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IShape;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractParentSlide;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.SlideMaster;
import com.benryan.pptx.record.Theme;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideLayout;
import org.openxmlformats.schemas.presentationml.x2006.main.SldLayoutDocument;

public class SlideLayout
extends AbstractParentSlide {
    CTSlideLayout layout;
    SlideMaster master;
    IShape[] myShapes;

    public SlideLayout(XMLSlideShow slideShow, PackagePart layoutPart, SldLayoutDocument layout, SlideMaster master, Theme theme, ColorScheme colorScheme) {
        super(slideShow, layoutPart, theme, colorScheme);
        this.master = master;
        this.layout = layout.getSldLayout();
        this.myShapes = super.getShapes();
    }

    @Override
    CTCommonSlideData getCommonSlideData() {
        return this.layout.getCSld();
    }

    @Override
    public IShape[] getShapes() {
        IShape[] retShapes = this.myShapes;
        if (!this.layout.isSetShowMasterSp() || this.layout.getShowMasterSp()) {
            IShape[] parentShapes = this.master.getShapes();
            IShape[] combined = new IShape[retShapes.length + parentShapes.length];
            System.arraycopy(parentShapes, 0, combined, 0, parentShapes.length);
            System.arraycopy(retShapes, 0, combined, parentShapes.length, retShapes.length);
            retShapes = combined;
        }
        return retShapes;
    }

    @Override
    public AbstractSlideModel getParent() {
        return this.master;
    }

    @Override
    SlideMaster getSlideMaster() {
        return this.master;
    }
}

