/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import java.awt.Color;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;

public class LineProperties {
    private double width;
    private Color color;

    public LineProperties() {
    }

    public LineProperties(LineProperties base) {
        if (base != null) {
            this.width = base.width;
            this.color = base.color;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setProperties(CTLineProperties ctLineProps, ColorScheme colorScheme) {
        CTNoFillProperties noFill;
        Color color = ColorScheme.resolveColor((XmlObject)ctLineProps.getSolidFill(), colorScheme);
        int width = ctLineProps.getW();
        if (color != null) {
            this.setColor(color);
        }
        if (width > 0) {
            this.setWidth((double)ctLineProps.getW() / 9525.0);
        }
        if ((noFill = ctLineProps.getNoFill()) != null) {
            this.setColor(null);
        }
    }

    public static LineProperties create(CTLineProperties ctLineProps, CTStyleMatrixReference lnRef, AbstractSlideModel slide) {
        LineProperties lineProps = new LineProperties();
        if (lnRef != null) {
            Color phColor = ColorScheme.resolveColor((XmlObject)lnRef, slide.getColorScheme());
            long index = lnRef.getIdx();
            if (index != 0L) {
                CTLineProperties lineStyle = slide.getTheme().getLineStyle((int)(index - 1L));
                Color refColor = ColorScheme.resolveColor((XmlObject)lineStyle.getSolidFill(), slide.getColorScheme(), phColor);
                phColor = refColor != null ? refColor : phColor;
                lineProps.setWidth((double)lineStyle.getW() / 9525.0);
                lineProps.setColor(phColor);
            }
        }
        if (ctLineProps != null) {
            lineProps.setProperties(ctLineProps, slide.getColorScheme());
        }
        return lineProps;
    }
}

