/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.XMLImageOptions;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.BackgroundPicture;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.XMLPictureData;
import java.awt.Color;
import java.awt.Paint;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;

public class FillProperties
implements Cloneable {
    Color color;
    BackgroundPicture pic;

    public FillProperties(XmlObject fillStyle, PackagePart mainPart, XMLSlideShow slideShow, ColorScheme colorScheme, Color fillColor) throws InvalidFormatException {
        this.initFillStyle(fillStyle, mainPart, slideShow, colorScheme, fillColor);
    }

    public FillProperties(XmlObject fillContainer, PackagePart mainPart, XMLSlideShow slideShow, ColorScheme colorScheme) throws InvalidFormatException {
        this.initProps(fillContainer, mainPart, slideShow, colorScheme);
    }

    public void initProps(XmlObject fillContainer, PackagePart mainPart, XMLSlideShow slideShow, ColorScheme colorScheme) throws InvalidFormatException {
        XmlObject[] children;
        for (XmlObject xmlObject : children = fillContainer.selectChildren(QNameSet.ALL)) {
            if (this.initFillStyle(xmlObject, mainPart, slideShow, colorScheme, null)) break;
        }
    }

    public FillProperties() {
        this.color = Color.black;
    }

    private boolean initFillStyle(XmlObject fillStyle, PackagePart mainPart, XMLSlideShow slideShow, ColorScheme colorScheme, Color fillColor) throws InvalidFormatException {
        if (fillStyle instanceof CTGradientFillProperties) {
            this.initGradientFill(fillStyle, colorScheme, fillColor);
            return true;
        }
        if (fillStyle instanceof CTSolidColorFillProperties) {
            this.color = ColorScheme.resolveColor(fillStyle, colorScheme, fillColor);
            return true;
        }
        if (fillStyle instanceof CTBlipFillProperties) {
            this.initBlipFill(fillStyle, mainPart, slideShow);
            return true;
        }
        return false;
    }

    private void initBlipFill(XmlObject fillStyle, PackagePart mainPart, XMLSlideShow slideShow) throws InvalidFormatException {
        CTBlipFillProperties blipFill = (CTBlipFillProperties)fillStyle;
        CTBlip blip = blipFill.getBlip();
        PackageRelationship pr = mainPart.getRelationship(blip.getEmbed());
        PackagePart part = slideShow.getTargetPart(pr);
        XMLPictureData picData = XMLPictureData.createFrom(part);
        XMLImageOptions options = new XMLImageOptions(blipFill);
        this.pic = new BackgroundPicture(picData, options);
    }

    private void initGradientFill(XmlObject fillStyle, ColorScheme colorScheme, Color fillColor) {
        CTGradientFillProperties gradientFill = (CTGradientFillProperties)fillStyle;
        CTGradientStopList gsLst = gradientFill.getGsLst();
        this.color = ColorScheme.resolveColor((XmlObject)gsLst.getGsArray(0), colorScheme, fillColor);
    }

    public Paint getFill() {
        return this.color;
    }

    public BackgroundPicture getPicture() {
        return this.pic;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isTiled() {
        return this.pic != null && this.pic.isTiled();
    }

    public static Paint getFillColor(XmlObject props, CTStyleMatrixReference fillRef, AbstractSlideModel slide) {
        XmlObject solidFill = FillProperties.getFillFromObject(props);
        if (solidFill == null && fillRef != null) {
            Color fill = ColorScheme.resolveColor((XmlObject)fillRef, slide.getColorScheme());
            if (fill == null) {
                long idx = fillRef.getIdx();
                if (idx != 0L) {
                    XmlObject fillStyle = slide.getTheme().getFillStyle((int)idx - 1);
                    if (fillStyle instanceof CTGradientFillProperties) {
                        CTGradientFillProperties gradientFill = (CTGradientFillProperties)fillStyle;
                        CTGradientStopList gsLst = gradientFill.getGsLst();
                        solidFill = gsLst.getGsArray(0);
                    } else if (fillStyle instanceof CTSolidColorFillProperties) {
                        solidFill = (CTSolidColorFillProperties)fillStyle;
                    }
                }
            } else if (fillRef.getIdx() != 0L) {
                return fill;
            }
        }
        return ColorScheme.resolveColor(solidFill, slide.getColorScheme());
    }

    private static XmlObject getFillFromObject(XmlObject object) {
        XmlObject[] selectChildren;
        if (object == null) {
            return null;
        }
        for (XmlObject xmlObject : selectChildren = object.selectChildren(QNameSet.ALL)) {
            if (xmlObject instanceof CTSolidColorFillProperties) {
                return xmlObject;
            }
            if (!(xmlObject instanceof CTGradientFillProperties)) continue;
            CTGradientStopList gsLst = ((CTGradientFillProperties)xmlObject).getGsLst();
            return gsLst.getGsArray(0);
        }
        return null;
    }
}

