/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.pptx.record.PresetColors;
import com.benryan.pptx.record.color.ColorAdjustments;
import java.awt.Color;
import java.util.HashMap;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHslColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTScRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSystemColor;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetColorVal;

public class ColorScheme {
    HashMap<String, Color> schemeColors = new HashMap();

    public ColorScheme(CTColorScheme colorScheme) {
        this.schemeColors.put("accent1", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent1()));
        this.schemeColors.put("accent2", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent2()));
        this.schemeColors.put("accent3", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent3()));
        this.schemeColors.put("accent4", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent4()));
        this.schemeColors.put("accent5", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent5()));
        this.schemeColors.put("accent6", ColorScheme.resolveColor((XmlObject)colorScheme.getAccent6()));
        this.schemeColors.put("dk1", ColorScheme.resolveColor((XmlObject)colorScheme.getDk1()));
        this.schemeColors.put("dk2", ColorScheme.resolveColor((XmlObject)colorScheme.getDk2()));
        this.schemeColors.put("folHlink", ColorScheme.resolveColor((XmlObject)colorScheme.getFolHlink()));
        this.schemeColors.put("lt1", ColorScheme.resolveColor((XmlObject)colorScheme.getLt1()));
        this.schemeColors.put("lt2", ColorScheme.resolveColor((XmlObject)colorScheme.getLt2()));
        this.schemeColors.put("hlink", ColorScheme.resolveColor((XmlObject)colorScheme.getHlink()));
    }

    public ColorScheme(CTColorMapping colorMapping, ColorScheme scheme) {
        this.schemeColors.put("accent1", ColorScheme.resolveSchemeColor(colorMapping.getAccent1().toString(), scheme, null));
        this.schemeColors.put("accent2", ColorScheme.resolveSchemeColor(colorMapping.getAccent2().toString(), scheme, null));
        this.schemeColors.put("accent3", ColorScheme.resolveSchemeColor(colorMapping.getAccent3().toString(), scheme, null));
        this.schemeColors.put("accent4", ColorScheme.resolveSchemeColor(colorMapping.getAccent4().toString(), scheme, null));
        this.schemeColors.put("accent5", ColorScheme.resolveSchemeColor(colorMapping.getAccent5().toString(), scheme, null));
        this.schemeColors.put("accent6", ColorScheme.resolveSchemeColor(colorMapping.getAccent6().toString(), scheme, null));
        this.schemeColors.put("bg1", ColorScheme.resolveSchemeColor(colorMapping.getBg1().toString(), scheme, null));
        this.schemeColors.put("bg2", ColorScheme.resolveSchemeColor(colorMapping.getBg2().toString(), scheme, null));
        this.schemeColors.put("folHlink", ColorScheme.resolveSchemeColor(colorMapping.getFolHlink().toString(), scheme, null));
        this.schemeColors.put("tx1", ColorScheme.resolveSchemeColor(colorMapping.getTx1().toString(), scheme, null));
        this.schemeColors.put("tx2", ColorScheme.resolveSchemeColor(colorMapping.getTx2().toString(), scheme, null));
        this.schemeColors.put("hlink", ColorScheme.resolveSchemeColor(colorMapping.getHlink().toString(), scheme, null));
        this.schemeColors.put("dk2", ColorScheme.resolveSchemeColor("dk2", scheme, null));
        this.schemeColors.put("dk1", ColorScheme.resolveSchemeColor("dk1", scheme, null));
        this.schemeColors.put("lt2", ColorScheme.resolveSchemeColor("lt2", scheme, null));
        this.schemeColors.put("lt1", ColorScheme.resolveSchemeColor("lt1", scheme, null));
    }

    public Color getSchemeColor(String name) {
        return this.schemeColors.get(name);
    }

    public static Color resolveColor(XmlObject color) {
        return ColorScheme.resolveColor(color, null);
    }

    public static Color resolveColor(XmlObject color, ColorScheme scheme) {
        return ColorScheme.resolveColor(color, scheme, null);
    }

    public static Color resolveColor(XmlObject color, ColorScheme scheme, Color phColor) {
        XmlObject[] children;
        if (color == null) {
            return null;
        }
        for (XmlObject xmlObject : children = color.selectChildren(QNameSet.ALL)) {
            if (xmlObject instanceof CTHslColor) {
                return ColorScheme.resolveHslColor((CTHslColor)xmlObject);
            }
            if (xmlObject instanceof CTScRgbColor) {
                return ColorScheme.resolveScrgbColor((CTScRgbColor)xmlObject);
            }
            if (xmlObject instanceof CTSRgbColor) {
                return ColorScheme.resolveSrgbColor((CTSRgbColor)xmlObject);
            }
            if (xmlObject instanceof CTPresetColor) {
                return ColorScheme.resolvePrstColor((CTPresetColor)xmlObject);
            }
            if (xmlObject instanceof CTSchemeColor) {
                return ColorScheme.resolveSchemeColor((CTSchemeColor)xmlObject, scheme, phColor);
            }
            if (!(xmlObject instanceof CTSystemColor)) continue;
            return ColorScheme.resolveSystemColor((CTSystemColor)xmlObject, scheme);
        }
        return Color.black;
    }

    private static Color resolveSystemColor(CTSystemColor sysColor, ColorScheme scheme) {
        byte[] val = sysColor.getLastClr();
        return ColorScheme.adjust(new Color(val[0] & 0xFF, val[1] & 0xFF, val[2] & 0xFF), (XmlObject)sysColor);
    }

    public static Color resolveHslColor(CTHslColor hslClr) {
        return ColorScheme.adjust(Color.getHSBColor((float)hslClr.getHue2() / 2.16E8f, (float)hslClr.getSat2() / 100000.0f, (float)hslClr.getLum2() / 100000.0f), (XmlObject)hslClr);
    }

    public static Color resolveScrgbColor(CTScRgbColor scrgbClr) {
        return ColorScheme.adjust(new Color((float)scrgbClr.getR() / 100000.0f, (float)scrgbClr.getG() / 100000.0f, (float)scrgbClr.getB() / 100000.0f), (XmlObject)scrgbClr);
    }

    public static Color resolveSrgbColor(CTSRgbColor srgbClr) {
        byte[] val = srgbClr.getVal();
        return ColorScheme.adjust(new Color(val[0] & 0xFF, val[1] & 0xFF, val[2] & 0xFF), (XmlObject)srgbClr);
    }

    public static Color resolvePrstColor(CTPresetColor prstClr) {
        STPresetColorVal.Enum val = prstClr.getVal();
        return ColorScheme.adjust(PresetColors.getPresetColor(val.toString()), (XmlObject)prstClr);
    }

    public static Color resolveSchemeColor(CTSchemeColor schemeColor, ColorScheme colorScheme, Color phColor) {
        return ColorScheme.adjust(ColorScheme.resolveSchemeColor(schemeColor.getVal().toString(), colorScheme, phColor), (XmlObject)schemeColor);
    }

    private static Color adjust(Color raw, XmlObject adjustmentObject) {
        return ColorAdjustments.adjust(raw, adjustmentObject);
    }

    public static Color resolveSchemeColor(String colorName, ColorScheme scheme, Color phColor) {
        if (scheme == null) {
            return null;
        }
        if (colorName.equals("phClr")) {
            return phColor;
        }
        return scheme.getSchemeColor(colorName);
    }
}

