/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.PptRenderer;
import com.benryan.pptx.record.ColorScheme;
import java.awt.Color;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBlipBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizeFollowText;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNoBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;

public class BulletStyle
implements Cloneable {
    boolean hasBullet;
    char bulletChar;
    double bulletSize = 100.0;
    String fontName;
    Color bulletColor = null;

    public BulletStyle() {
    }

    public BulletStyle(CTTextParagraphProperties props, ColorScheme colorScheme) {
        this.initProps(props, colorScheme);
    }

    void initProps(CTTextParagraphProperties props, ColorScheme colorScheme) {
        XmlObject[] children;
        for (XmlObject xmlObject : children = props.selectChildren(QNameSet.ALL)) {
            if (xmlObject instanceof CTTextAutonumberBullet) {
                this.bulletChar = (char)8226;
                this.hasBullet = true;
                return;
            }
            if (xmlObject instanceof CTTextBlipBullet) {
                this.bulletChar = (char)8226;
                this.hasBullet = true;
                return;
            }
            if (xmlObject instanceof CTTextCharBullet) {
                CTTextCharBullet charBullet = (CTTextCharBullet)xmlObject;
                String charString = charBullet.getChar();
                if (charString != null) {
                    this.bulletChar = charString.charAt(0);
                }
                this.hasBullet = true;
                break;
            }
            if (!(xmlObject instanceof CTTextNoBullet)) continue;
            this.hasBullet = false;
        }
        if (this.hasBullet) {
            CTTextFont fontText;
            Color color;
            CTColor buClr = props.getBuClr();
            if (buClr != null && (color = ColorScheme.resolveColor((XmlObject)buClr, colorScheme)) != null) {
                this.bulletColor = color;
            }
            if ((fontText = props.getBuFont()) != null) {
                this.fontName = fontText.getTypeface();
            }
            CTTextBulletSizePercent buSzPct = props.getBuSzPct();
            CTTextBulletSizePoint buSzPts = props.getBuSzPts();
            CTTextBulletSizeFollowText buSzTx = props.getBuSzTx();
            if (buSzPct != null) {
                this.bulletSize = (double)buSzPct.getVal() / 1000.0;
            } else if (buSzPts != null) {
                this.bulletSize = -((double)buSzPts.getVal() / 100.0 * PptRenderer.POINTS_TO_PIXELS);
            }
        }
        if (props.getBuFontTx() != null) {
            this.fontName = null;
        }
    }

    public double getBulletSize() {
        return this.bulletSize;
    }

    public char getBulletChar() {
        return this.bulletChar;
    }

    public Color getBulletColor() {
        return this.bulletColor;
    }

    public String getBulletFontName() {
        return this.fontName;
    }

    public boolean hasBullet() {
        return this.hasBullet;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

