/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IShape;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.Background;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.FillProperties;
import com.benryan.pptx.record.PlaceholderCoordinates;
import com.benryan.pptx.record.SlideMaster;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLAutoShape;
import com.benryan.pptx.record.XMLGroupShape;
import com.benryan.pptx.record.XMLLine;
import com.benryan.pptx.record.XMLParagraphStyle;
import com.benryan.pptx.record.XMLPicture;
import com.benryan.pptx.record.XMLShape;
import com.benryan.pptx.record.XMLTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackgroundProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public abstract class AbstractSlideModel {
    protected XMLSlideShow slideShow;
    protected PackagePart mainPart;
    private Theme theme;
    protected ColorScheme colorScheme;
    private List<IShape> shapes;
    private Background background;

    public AbstractSlideModel(XMLSlideShow slideShow, PackagePart mainPart, Theme theme, ColorScheme colorScheme) {
        this.slideShow = slideShow;
        this.mainPart = mainPart;
        this.theme = theme;
        this.colorScheme = colorScheme;
    }

    public abstract AbstractSlideModel getParent();

    public abstract XMLShape getPlaceholder(PlaceholderCoordinates var1);

    public PackagePart getPackagePart() {
        return this.mainPart;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    protected List<IShape> retrieveAndSortShapes(CTGroupShape shapeTree) throws InvalidFormatException, IOException {
        XmlObject[] children = shapeTree.selectChildren(QNameSet.ALL);
        ArrayList<IShape> shapes = new ArrayList<IShape>(children.length);
        for (XmlObject xmlObject : children) {
            IShape shape = null;
            if (xmlObject instanceof CTPicture) {
                CTPicture pic = (CTPicture)xmlObject;
                shape = new XMLPicture(this.slideShow, this, pic);
            } else if (xmlObject instanceof CTShape) {
                CTShape ctShape = (CTShape)xmlObject;
                shape = new XMLAutoShape(this.slideShow, this, ctShape);
            } else if (xmlObject instanceof CTGroupShape) {
                CTGroupShape ctGroupShape = (CTGroupShape)xmlObject;
                List<IShape> groupShapes = this.retrieveAndSortShapes(ctGroupShape);
                shape = new XMLGroupShape(this.slideShow, this, ctGroupShape, groupShapes);
            } else if (xmlObject instanceof CTConnector) {
                CTConnector ctLine = (CTConnector)xmlObject;
                shape = new XMLLine(this.slideShow, this, ctLine);
            } else {
                XmlObject[] selectChildren;
                CTGraphicalObjectData graphicData;
                if (!(xmlObject instanceof CTGraphicalObjectFrame)) continue;
                CTGraphicalObjectFrame frame = (CTGraphicalObjectFrame)xmlObject;
                CTGraphicalObject graphic = frame.getGraphic();
                if (graphic != null && (graphicData = graphic.getGraphicData()) != null && (selectChildren = graphicData.selectChildren(QNameSet.ALL)).length > 0 && selectChildren[0] instanceof CTTable) {
                    shape = new XMLTable(frame, this, (CTTable)selectChildren[0]);
                }
            }
            if (shape == null) continue;
            shapes.add(shape);
            this.acceptShape(shape);
        }
        return shapes;
    }

    public IShape[] getShapes() {
        if (this.shapes == null) {
            try {
                this.shapes = this.retrieveAndSortShapes(this.getShapeTree());
            }
            catch (InvalidFormatException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.shapes.toArray(new IShape[this.shapes.size()]);
    }

    public Background getBackground() {
        if (this.background == null) {
            CTBackground bg = this.getCommonSlideData().getBg();
            XmlObject fillStyle = null;
            Color fillColor = null;
            PackagePart bgRefPart = this.mainPart;
            if (bg != null) {
                CTBackgroundProperties bgPr = bg.getBgPr();
                CTStyleMatrixReference bgRef = bg.getBgRef();
                if (bgPr != null) {
                    XmlObject[] children = bgPr.selectChildren(QNameSet.ALL);
                    if (children.length > 0) {
                        fillStyle = children[0];
                    }
                } else if (bgRef != null) {
                    fillColor = ColorScheme.resolveColor((XmlObject)bgRef, this.colorScheme);
                    long idx = bgRef.getIdx();
                    bgRefPart = this.theme.getPackagePart();
                    if (idx < 1000L && idx > 0L) {
                        fillStyle = this.theme.getFillStyle((int)idx - 1);
                    } else if (idx > 1000L) {
                        fillStyle = this.theme.getBgFillStyle((int)idx - 1001);
                    }
                }
            }
            if (fillStyle != null) {
                try {
                    this.background = new Background(new FillProperties(fillStyle, bgRefPart, this.slideShow, this.colorScheme, fillColor));
                }
                catch (InvalidFormatException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        AbstractSlideModel parent = this.getParent();
        if (this.background == null && parent != null) {
            this.background = parent.getBackground();
        }
        return this.background;
    }

    public void loadListLevels(CTTextListStyle style, Map<Integer, XMLParagraphStyle> defaults) {
        CTTextParagraphProperties lvlPPr;
        CTTextParagraphProperties defPPr = style.getDefPPr();
        XMLParagraphStyle defaultStyle = null;
        if (defPPr != null) {
            defaultStyle = new XMLParagraphStyle(defPPr, this.mainPart, this.slideShow, this.theme, this.colorScheme);
        }
        if ((lvlPPr = style.getLvl1PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 0);
        }
        if ((lvlPPr = style.getLvl2PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 1);
        }
        if ((lvlPPr = style.getLvl3PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 2);
        }
        if ((lvlPPr = style.getLvl4PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 3);
        }
        if ((lvlPPr = style.getLvl5PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 4);
        }
        if ((lvlPPr = style.getLvl6PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 5);
        }
        if ((lvlPPr = style.getLvl7PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 6);
        }
        if ((lvlPPr = style.getLvl8PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 7);
        }
        if ((lvlPPr = style.getLvl9PPr()) != null) {
            this.loadStyle(defaults, defaultStyle, lvlPPr, 8);
        }
    }

    private void loadStyle(Map<Integer, XMLParagraphStyle> defaults, XMLParagraphStyle defaultStyle, CTTextParagraphProperties lvlPPr, int lvlNum) {
        XMLParagraphStyle newStyle = defaultStyle != null ? new XMLParagraphStyle(defaultStyle) : new XMLParagraphStyle();
        newStyle.initProps(lvlPPr, this.mainPart, this.slideShow, this.theme, this.colorScheme);
        defaults.put(lvlNum, newStyle);
    }

    public void loadListLevels(CTTextListStyle style, Map<Integer, XMLParagraphStyle> parent, Map<Integer, XMLParagraphStyle> defaults) {
        XMLParagraphStyle xmlParagraphStyle;
        CTTextParagraphProperties lvlPPr = style.getLvl1PPr();
        if (lvlPPr != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 0);
            defaults.put(0, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl2PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 1);
            defaults.put(1, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl3PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 2);
            defaults.put(2, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl4PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 3);
            defaults.put(3, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl5PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 4);
            defaults.put(4, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl6PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 5);
            defaults.put(5, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl7PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 6);
            defaults.put(6, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl8PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 7);
            defaults.put(7, xmlParagraphStyle);
        }
        if ((lvlPPr = style.getLvl9PPr()) != null) {
            xmlParagraphStyle = this.getParagraphStyle(parent, lvlPPr, 8);
            defaults.put(8, xmlParagraphStyle);
        }
    }

    private XMLParagraphStyle getParagraphStyle(Map<Integer, XMLParagraphStyle> parent, CTTextParagraphProperties lvlPPr, int index) {
        XMLParagraphStyle xmlParagraphStyle = parent.get(index);
        if (xmlParagraphStyle != null) {
            xmlParagraphStyle = new XMLParagraphStyle(xmlParagraphStyle);
            xmlParagraphStyle.initProps(lvlPPr, this.mainPart, this.slideShow, this.theme, this.colorScheme);
        } else {
            xmlParagraphStyle = new XMLParagraphStyle(lvlPPr, this.mainPart, this.slideShow, this.theme, this.colorScheme);
        }
        return xmlParagraphStyle;
    }

    protected CTGroupShape getShapeTree() {
        return this.getCommonSlideData().getSpTree();
    }

    abstract CTCommonSlideData getCommonSlideData();

    abstract void acceptShape(IShape var1);

    abstract SlideMaster getSlideMaster();

    public Theme getTheme() {
        return this.theme;
    }

    public XMLSlideShow getSlideShow() {
        return this.slideShow;
    }
}

