/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.escher.CustomShapeRenderer;
import com.benryan.escher.XmlCustomShapeRenderer;
import com.benryan.ppt.api.Transformer;
import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.gen.xml.XMLShapeFinder;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.LineProperties;
import com.benryan.pptx.record.XMLAutoShape;
import com.benryan.pptx.record.XMLShape;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuideList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;

public abstract class AbstractSingleShape
extends XMLShape {
    public AbstractSingleShape(XMLSlideShow slideshow, AbstractSlideModel slide, CTApplicationNonVisualDrawingProps nvPr) {
        super(slideshow, slide, nvPr);
    }

    @Override
    public boolean isHFlipped() {
        return this.getTransform2d().getFlipH();
    }

    @Override
    public boolean isVFlipped() {
        return this.getTransform2d().getFlipV();
    }

    public CTTransform2D getTransform2d() {
        CTTransform2D transform2d = this.getShapeProperties().getXfrm();
        if (transform2d == null && this.coordinates != null) {
            XMLShape placeholder;
            for (AbstractSlideModel current = this.slide.getParent(); !(current == null || (placeholder = current.getPlaceholder(this.coordinates)) != null && placeholder instanceof AbstractSingleShape && (transform2d = ((AbstractSingleShape)placeholder).getTransform2d()) != null); current = current.getParent()) {
            }
        }
        return transform2d;
    }

    @Override
    public Rectangle2D.Double getAnchor() {
        CTTransform2D transform2d = this.getTransform2d();
        CTPoint2D offset = transform2d.getOff();
        CTPositiveSize2D extent = transform2d.getExt();
        Rectangle anchor = new Rectangle((int)offset.getX(), (int)offset.getY(), (int)extent.getCx(), (int)extent.getCy());
        return Transformer.transformRectangle(anchor);
    }

    @Override
    public float getRotation() {
        return (float)this.getTransform2d().getRot() / 60000.0f;
    }

    protected LineProperties getLineProperties() {
        CTShapeStyle style = this.getStyle();
        return LineProperties.create(this.getCTLineProps(), style != null ? style.getLnRef() : null, this.slide);
    }

    @Override
    protected boolean hasNoFill() {
        return this.getShapeProperties().getNoFill() != null;
    }

    @Override
    protected XmlObject getFillFromShape() {
        CTGradientStopList gsLst;
        CTShapeProperties shapeProperties = this.getShapeProperties();
        CTSolidColorFillProperties solidFill = shapeProperties.getSolidFill();
        if (solidFill != null) {
            return solidFill;
        }
        CTGradientFillProperties gradFill = shapeProperties.getGradFill();
        if (gradFill != null && (gsLst = gradFill.getGsLst()) != null && gsLst.sizeOfGsArray() > 0) {
            return gsLst.getGsArray(0);
        }
        return null;
    }

    @Override
    protected CTLineProperties getLineFromShape() {
        return this.getShapeProperties().getLn();
    }

    public abstract CTShapeProperties getShapeProperties();

    public boolean isUserDefined() {
        boolean custom;
        boolean bl = custom = this.getShapeProperties().getPrstGeom() == null;
        if (custom && this.placeholder != null && this.placeholder instanceof XMLAutoShape) {
            return ((XMLAutoShape)this.placeholder).isUserDefined();
        }
        return custom;
    }

    public Autoshape getPredefinedShape(Rectangle2D rec) {
        CTPresetGeometry2D prstGeom = this.getShapeProperties().getPrstGeom();
        if (prstGeom != null) {
            STShapeType.Enum prst = prstGeom.getPrst();
            String shapeName = prst.toString();
            Autoshape autoShape = XMLShapeFinder.getAutoShape(shapeName);
            CTGeomGuideList avLst = prstGeom.getAvLst();
            CTGeomGuide[] gdArray = avLst.getGdArray();
            double[] adjustments = new double[gdArray.length];
            for (int x = 0; x < gdArray.length; ++x) {
                String[] parts = gdArray[x].getFmla().split(" ");
                adjustments[x] = Double.parseDouble(parts[1]);
            }
            autoShape.initShape(adjustments);
            return autoShape;
        }
        if (this.placeholder != null && this.placeholder instanceof XMLAutoShape) {
            return ((XMLAutoShape)this.placeholder).getPredefinedShape(rec);
        }
        return null;
    }

    public CustomShapeRenderer getCustomShapeRenderer() {
        return new XmlCustomShapeRenderer();
    }
}

