/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx.record;

import com.benryan.ppt.api.IShape;
import com.benryan.pptx.XMLSlideShow;
import com.benryan.pptx.record.AbstractSlideModel;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.PlaceholderCoordinates;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLShape;
import java.util.HashMap;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

public abstract class AbstractParentSlide
extends AbstractSlideModel {
    HashMap<STPlaceholderType.Enum, XMLShape> layoutShapesByType = new HashMap();
    HashMap<Integer, XMLShape> layoutShapesByIdx = new HashMap();

    public AbstractParentSlide(XMLSlideShow slideShow, PackagePart mainPart, Theme theme, ColorScheme colorScheme) {
        super(slideShow, mainPart, theme, colorScheme);
    }

    @Override
    void acceptShape(IShape shape) {
        PlaceholderCoordinates coordinates;
        if (shape instanceof XMLShape && (coordinates = ((XMLShape)shape).getCoordinates()) != null) {
            if (coordinates.getType() != null) {
                this.layoutShapesByType.put(coordinates.getType(), (XMLShape)shape);
            }
            if (coordinates.getIdx() > 0) {
                this.layoutShapesByIdx.put(coordinates.getIdx(), (XMLShape)shape);
            }
        }
    }

    @Override
    public XMLShape getPlaceholder(PlaceholderCoordinates coordinates) {
        XMLShape xmlShape;
        STPlaceholderType.Enum type = coordinates.getType();
        int idx = coordinates.getIdx();
        if (idx > 0 && (xmlShape = this.layoutShapesByIdx.get(idx)) != null) {
            return xmlShape;
        }
        if (type != null && (xmlShape = this.layoutShapesByType.get(type)) != null) {
            return xmlShape;
        }
        return null;
    }
}

