/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx;

import com.benryan.ppt.api.Transformer;
import com.benryan.ppt.api.model.ISlide;
import com.benryan.ppt.api.usermodel.ISlideShow;
import com.benryan.pptx.SecureXmlUtils;
import com.benryan.pptx.record.ColorScheme;
import com.benryan.pptx.record.SlideLayout;
import com.benryan.pptx.record.SlideMaster;
import com.benryan.pptx.record.Theme;
import com.benryan.pptx.record.XMLSlide;
import com.benryan.pptx.record.XMLTableStyle;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.TblStyleLstDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.SldLayoutDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;
import org.xml.sax.SAXException;

public class XMLSlideShow
implements ISlideShow {
    public static final String TABLE_STYLES_RELATION_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/tableStyles";
    public static final String OLE_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    public static final String PACK_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    private final PresentationDocument presentationDoc;
    private final PackagePart packagePart;
    private final OPCPackage opcPackage;
    private final File tmpFile;
    private final CTSlideIdListEntry[] entries;
    private final Map<String, XMLTableStyle> tableStyles;

    private XMLSlideShow(OPCPackage opcPackage, File tmpFile) throws OpenXML4JException, IOException, XmlException, SAXException, ParserConfigurationException {
        this.opcPackage = opcPackage;
        this.tmpFile = tmpFile;
        PackageRelationship coreRel = opcPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.packagePart = opcPackage.getPart(coreRel);
        this.presentationDoc = PresentationDocument.Factory.parse((InputStream)this.packagePart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        this.entries = this.getSlideReferences().getSldIdArray();
        PackagePart tableStylesPart = this.getRelatedPackageByType(this.packagePart, TABLE_STYLES_RELATION_TYPE);
        this.tableStyles = tableStylesPart != null ? XMLSlideShow.loadTableStyles(tableStylesPart) : null;
        for (CTSlideIdListEntry ctSlide : this.entries) {
            PackagePart slidePart = this.getTargetPart(this.packagePart.getRelationship(ctSlide.getId2()));
            for (PackageRelationship rel : slidePart.getRelationshipsByType(OLE_OBJECT_REL_TYPE)) {
                embedds.add(this.getTargetPart(rel));
            }
            for (PackageRelationship rel : slidePart.getRelationshipsByType(PACK_OBJECT_REL_TYPE)) {
                embedds.add(this.getTargetPart(rel));
            }
        }
    }

    public static XMLSlideShow createSlideshow(InputStream in) throws OpenXML4JException, IOException, XmlException, SAXException, ParserConfigurationException {
        try {
            File tmpFile = XMLSlideShow.copyStreamToFile(in);
            OPCPackage opcPackage = OPCPackage.open((String)tmpFile.getAbsolutePath(), (PackageAccess)PackageAccess.READ);
            return new XMLSlideShow(opcPackage, tmpFile);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File copyStreamToFile(InputStream in) throws IOException {
        File tmpFile = File.createTempFile(XMLSlideShow.class.getName(), null);
        tmpFile.deleteOnExit();
        try (OutputStream outputStream = null;){
            outputStream = new BufferedOutputStream(new FileOutputStream(tmpFile));
            IOUtils.copy((InputStream)in, (OutputStream)outputStream);
        }
        return tmpFile;
    }

    public CTPresentation getPresentation() {
        return this.presentationDoc.getPresentation();
    }

    private CTSlideIdList getSlideReferences() {
        return this.getPresentation().getSldIdLst();
    }

    private PackagePart getSlidePart(CTSlideIdListEntry slide) throws IOException, XmlException {
        try {
            return this.getTargetPart(this.packagePart.getRelationship(slide.getId2()));
        }
        catch (InvalidFormatException e) {
            throw new XmlException((Throwable)e);
        }
    }

    private XMLSlide getXMLSlide(int index) throws IOException, XmlException, InvalidFormatException, SAXException, ParserConfigurationException {
        CTSlideIdListEntry slideId = this.entries[index];
        PackagePart slidePart = this.getSlidePart(slideId);
        PackagePart layoutPart = this.getRelatedPackageByType(slidePart, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout");
        SldLayoutDocument layout = SldLayoutDocument.Factory.parse((InputStream)layoutPart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        PackagePart masterPart = this.getRelatedPackageByType(layoutPart, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster");
        SldMasterDocument master = SldMasterDocument.Factory.parse((InputStream)masterPart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        PackagePart themePart = this.getRelatedPackageByType(masterPart, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme");
        Theme theme = new Theme(themePart);
        ColorScheme themeScheme = theme.getColorScheme();
        ColorScheme colorScheme = new ColorScheme(master.getSldMaster().getClrMap(), themeScheme);
        SlideMaster slideMaster = new SlideMaster(this, masterPart, master, theme, colorScheme);
        SlideLayout slideLayout = new SlideLayout(this, layoutPart, layout, slideMaster, theme, colorScheme);
        return new XMLSlide(this, slidePart, slideLayout, slideMaster, theme, colorScheme);
    }

    public PackagePart getTargetPart(PackageRelationship rel) throws InvalidFormatException {
        return XMLSlideShow.getTargetPart(this.opcPackage, rel);
    }

    private static PackagePart getTargetPart(OPCPackage pkg, PackageRelationship rel) throws InvalidFormatException {
        PackagePartName relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
        PackagePart part = pkg.getPart(relName);
        if (part == null) {
            throw new IllegalArgumentException("No part found for relationship " + rel);
        }
        return part;
    }

    private PackagePart getRelatedPackageByType(PackagePart start, String type) throws InvalidFormatException {
        PackageRelationshipCollection collection = start.getRelationshipsByType(type);
        if (collection.size() > 0) {
            PackageRelationship pr = collection.getRelationship(0);
            return this.getTargetPart(pr);
        }
        return null;
    }

    @Override
    public Dimension getPageSize() {
        int cx = this.getPresentation().getSldSz().getCx();
        int cy = this.getPresentation().getSldSz().getCy();
        return new Dimension((int)Transformer.convert(cx), (int)Transformer.convert(cy));
    }

    @Override
    public ISlide getSlide(int i) {
        try {
            return this.getXMLSlide(i);
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.opcPackage.revert();
        this.tmpFile.delete();
    }

    @Override
    public int getSlideCount() {
        return this.entries.length;
    }

    private static Map<String, XMLTableStyle> loadTableStyles(PackagePart tableStylesPart) throws XmlException, IOException, SAXException, ParserConfigurationException {
        CTTableStyle[] tblStyleArray;
        HashMap<String, XMLTableStyle> tableStyles = new HashMap<String, XMLTableStyle>();
        TblStyleLstDocument tableStylesDoc = TblStyleLstDocument.Factory.parse((InputStream)tableStylesPart.getInputStream(), (XmlOptions)SecureXmlUtils.createSecureXmlOptions());
        CTTableStyleList tblStyleLst = tableStylesDoc.getTblStyleLst();
        for (CTTableStyle ctTableStyle : tblStyleArray = tblStyleLst.getTblStyleArray()) {
            XMLTableStyle tableStyle = new XMLTableStyle(ctTableStyle);
            tableStyles.put(ctTableStyle.getStyleId(), tableStyle);
        }
        return tableStyles;
    }

    public XMLTableStyle getTableStyle(String tableStyleId) {
        return this.tableStyles.get(tableStyleId);
    }
}

