/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.pptx;

import com.benryan.ppt.api.util.ImageOptions;
import com.benryan.pptx.record.ColorScheme;
import java.awt.Color;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorChangeEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRelativeRect;

public class XMLImageOptions
implements ImageOptions {
    private static final double DIVISOR = 100000.0;
    private CTBlipFillProperties props;
    private CTRelativeRect srcRect;
    Color transparency;

    public XMLImageOptions(CTBlipFillProperties props) {
        CTColorChangeEffect[] clrChangeArray;
        this.props = props;
        for (CTColorChangeEffect ctColorChangeEffect : clrChangeArray = props.getBlip().getClrChangeArray()) {
            CTColor clrFrom = ctColorChangeEffect.getClrFrom();
            this.transparency = ColorScheme.resolveColor((XmlObject)clrFrom);
            if (this.transparency != null) break;
        }
        this.srcRect = this.getSourceRectangle();
    }

    public boolean isTiled() {
        return this.props.getTile() != null;
    }

    @Override
    public double getCropBottom() {
        return this.srcRect == null ? 0.0 : (double)this.srcRect.getB() / 100000.0;
    }

    private CTRelativeRect getSourceRectangle() {
        return this.props.getSrcRect();
    }

    @Override
    public double getCropLeft() {
        return this.srcRect == null ? 0.0 : (double)this.srcRect.getL() / 100000.0;
    }

    @Override
    public double getCropRight() {
        return this.srcRect == null ? 0.0 : (double)this.srcRect.getR() / 100000.0;
    }

    @Override
    public double getCropTop() {
        return this.srcRect == null ? 0.0 : (double)this.srcRect.getT() / 100000.0;
    }

    @Override
    public Color getTransparency() {
        return this.transparency;
    }
}

