/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.path;

import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PathCreator {
    public void angleEllipse(GeneralPath path, double[] args) {
        this.checkForValidState(path, args);
        for (int x = 0; x < args.length; x += 6) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2] * 2.0;
            double argD = args[x + 3] * 2.0;
            double argE = args[x + 4] / 65536.0;
            double argF = args[x + 5] / 65536.0;
            double xOrg = argA - argC / 2.0;
            double yOrg = argB - argD / 2.0;
            Arc2D.Double arc = new Arc2D.Double(xOrg, yOrg, argC, argD, argE, argF, 0);
            path.append(arc, true);
        }
    }

    public void angleEllipseTo(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 6) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2] * 2.0;
            double argD = args[x + 3] * 2.0;
            double argE = args[x + 4] / 65536.0;
            double argF = args[x + 5] / 65536.0;
            double xOrg = argA - argC / 2.0;
            double yOrg = argB - argD / 2.0;
            Arc2D.Double arc = new Arc2D.Double(xOrg, yOrg, argC, argD, argE, argF, 0);
            path.append(arc, true);
        }
    }

    public void arc(GeneralPath path, double[] args) {
        this.checkForValidState(path, args);
        for (int x = 0; x < args.length; x += 8) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            double argG = args[x + 6];
            double argH = args[x + 7];
            double width = argC - argA;
            double height = argD - argB;
            Arc2D.Double arc = new Arc2D.Double();
            arc.setFrame(argA, argB, width, height);
            arc.setAngles(new Point2D.Double(argE, argF), new Point2D.Double(argG, argH));
            path.append(arc, true);
        }
    }

    public void arcTo(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 8) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            double argG = args[x + 6];
            double argH = args[x + 7];
            double width = argC - argA;
            double height = argD - argB;
            Arc2D.Double arc = new Arc2D.Double();
            arc.setFrame(argA, argB, width, height);
            arc.setAngles(new Point2D.Double(argE, argF), new Point2D.Double(argG, argH));
            path.append(arc, true);
        }
    }

    public void clockwiseArc(GeneralPath path, double[] args) {
        this.checkForValidState(path, args);
        for (int x = 0; x < args.length; x += 8) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            double argG = args[x + 6];
            double argH = args[x + 7];
            double width = argC - argA;
            double height = argD - argB;
            Arc2D.Double arc = new Arc2D.Double();
            arc.setFrame(argA, argB, width, height);
            arc.setAngles(new Point2D.Double(argG, argH), new Point2D.Double(argE, argF));
            double extent = ((Arc2D)arc).getAngleExtent();
            arc.setAngleStart(new Point2D.Double(argE, argF));
            ((Arc2D)arc).setAngleExtent(0.0 - extent);
            path.append(arc, true);
        }
    }

    public void clockwiseArcTo(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 8) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            double argG = args[x + 6];
            double argH = args[x + 7];
            double width = argC - argA;
            double height = argD - argB;
            double orgX = argA + width / 2.0;
            double orgY = argB + height / 2.0;
            double startAngle = Math.toDegrees(Math.atan2(-(argF - orgY), argE - orgX));
            double endAngle = Math.toDegrees(Math.atan2(-(argH - orgY), argG - orgX));
            Arc2D.Double arc = new Arc2D.Double();
            endAngle = endAngle > 0.0 ? 0.0 - (360.0 - endAngle) : endAngle;
            arc.setFrame(argA, argB, width, height);
            arc.setAngles(new Point2D.Double(argG, argH), new Point2D.Double(argE, argF));
            double extent = ((Arc2D)arc).getAngleExtent();
            arc.setAngleStart(new Point2D.Double(argE, argF));
            ((Arc2D)arc).setAngleExtent(0.0 - extent);
            path.append(arc, true);
        }
    }

    public void curveTo(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        int numCurves = args.length / 6;
        for (int x = 0; x < args.length; x += 6) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            CubicCurve2D.Double curve = new CubicCurve2D.Double(path.getCurrentPoint().getX(), path.getCurrentPoint().getY(), argA, argB, argC, argD, argE, argF);
            path.append(curve, true);
        }
    }

    public void curveToRelative(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        int numCurves = args.length / 6;
        for (int x = 0; x < args.length; x += 6) {
            double argA = args[x + 0];
            double argB = args[x + 1];
            double argC = args[x + 2];
            double argD = args[x + 3];
            double argE = args[x + 4];
            double argF = args[x + 5];
            CubicCurve2D.Double curve = new CubicCurve2D.Double(path.getCurrentPoint().getX(), path.getCurrentPoint().getY(), argA + path.getCurrentPoint().getX(), argB + path.getCurrentPoint().getY(), argC + path.getCurrentPoint().getX(), argD + path.getCurrentPoint().getY(), path.getCurrentPoint().getX() + argE, path.getCurrentPoint().getY() + argF);
            path.append(curve, true);
        }
    }

    public void ellipticalQuadrantX(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 2) {
            double argA = args[x];
            double argB = args[x + 1];
            if (x / 2 % 2 == 0) {
                this.quarterEllipseX(path, argA, argB);
                continue;
            }
            this.quarterEllipseY(path, argA, argB);
        }
    }

    private void quarterEllipseY(GeneralPath path, double argA, double argB) {
        double startX = path.getCurrentPoint().getX();
        double startY = path.getCurrentPoint().getY();
        double width = Math.abs(startX - argA) * 2.0;
        double height = Math.abs(startY - argB) * 2.0;
        double xOrg = 0.0;
        double yOrg = 0.0;
        double angle = 90.0;
        xOrg = startX > argA ? startX - width : startX;
        yOrg = startY > argB ? argB : argB - height;
        if (startX < argA && startY > argB || startX > argA && startY < argB) {
            angle = -90.0;
        }
        Arc2D.Double arc = new Arc2D.Double();
        ((Arc2D)arc).setArc(xOrg, yOrg, width, height, startX < argA ? 180.0 : 0.0, angle, 0);
        path.append(arc, true);
    }

    public void ellipticalQuadrantY(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        int numPoints = args.length / 2;
        for (int x = 0; x < args.length; x += 2) {
            double argA = args[x];
            double argB = args[x + 1];
            if (x / 2 % 2 == 0) {
                this.quarterEllipseY(path, argA, argB);
                continue;
            }
            this.quarterEllipseX(path, argA, argB);
        }
    }

    private void quarterEllipseX(GeneralPath path, double argA, double argB) {
        double startX = path.getCurrentPoint().getX();
        double startY = path.getCurrentPoint().getY();
        double width = Math.abs(startX - argA) * 2.0;
        double height = Math.abs(startY - argB) * 2.0;
        double xOrg = 0.0;
        double yOrg = 0.0;
        double angle = 90.0;
        xOrg = startX > argA ? argA : argA - width;
        yOrg = startY > argB ? startY - height : startY;
        if (startX < argA && startY < argB || startX > argA && startY > argB) {
            angle = -90.0;
        }
        Arc2D.Double arc = new Arc2D.Double();
        ((Arc2D)arc).setArc(xOrg, yOrg, width, height, startY > argB ? 270.0 : 90.0, angle, 0);
        path.append(arc, true);
    }

    public void lineTo(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 2) {
            double argA = args[x];
            double argB = args[x + 1];
            path.lineTo((float)argA, (float)argB);
        }
    }

    public void lineToRelative(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        for (int x = 0; x < args.length; x += 2) {
            double argA = args[x];
            double argB = args[x + 1];
            path.lineTo((float)(path.getCurrentPoint().getX() + argA), (float)(path.getCurrentPoint().getY() + argB));
        }
    }

    public void moveTo(GeneralPath path, double[] args) {
        args = this.checkLength(args, 2);
        double argA = args[0];
        double argB = args[1];
        path.moveTo((float)argA, (float)argB);
    }

    private double[] checkLength(double[] args, int multiple) {
        if (args.length % multiple != 0) {
            int newLen = multiple - args.length % multiple;
            double[] newArgs = new double[newLen += args.length];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            return newArgs;
        }
        return args;
    }

    public void moveToRelative(GeneralPath path, double[] args) {
        double argA = args[0];
        double argB = args[1];
        path.moveTo((float)(argA + path.getCurrentPoint().getX()), (float)(argB + path.getCurrentPoint().getY()));
    }

    public void quadraticBezier(GeneralPath path, double[] args) {
        this.checkForValidState(path);
        double xCenter = path.getCurrentPoint().getX();
        double yCenter = path.getCurrentPoint().getY();
        int count = args.length / 2;
        for (int x = 0; x < args.length; x += 2) {
            double argA = args[x];
            double argB = args[x + 1];
            xCenter = path.getCurrentPoint().getX() * 2.0 - xCenter;
            yCenter = path.getCurrentPoint().getY() * 2.0 - yCenter;
            path.quadTo((float)xCenter, (float)yCenter, (float)argA, (float)argB);
        }
    }

    private void checkForValidState(GeneralPath path) {
        this.checkForValidState(path, null);
    }

    private void checkForValidState(GeneralPath path, double[] args) {
        if (path.getCurrentPoint() == null) {
            if (args == null) {
                path.moveTo(0.0f, 0.0f);
            } else {
                path.moveTo((float)args[0], (float)args[1]);
            }
        }
    }
}

