/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WedgeRoundRectCallout
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{-20833.0, 62500.0, 16667.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double dxPos = this.getWidth() * this.adjustments[0] / 100000.0;
        double dyPos = this.getHeight() * this.adjustments[1] / 100000.0;
        double xPos = this.getWidth() / 2.0 + dxPos - 0.0;
        double yPos = this.getHeight() / 2.0 + dyPos - 0.0;
        double dq = dxPos * this.getHeight() / this.getWidth();
        double ady = Math.abs(dyPos);
        double adq = Math.abs(dq);
        double dz = ady + 0.0 - adq;
        double xg1 = dxPos > 0.0 ? 7 : 2;
        double xg2 = dxPos > 0.0 ? 10 : 5;
        double x1 = this.getWidth() * xg1 / 12.0;
        double x2 = this.getWidth() * xg2 / 12.0;
        double yg1 = dyPos > 0.0 ? 7 : 2;
        double yg2 = dyPos > 0.0 ? 10 : 5;
        double y1 = this.getHeight() * yg1 / 12.0;
        double y2 = this.getHeight() * yg2 / 12.0;
        double t1 = dxPos > 0.0 ? (double)this.getOrigin().x : xPos;
        double xl = dz > 0.0 ? (double)this.getOrigin().x : t1;
        double t2 = dyPos > 0.0 ? x1 : xPos;
        double xt = dz > 0.0 ? t2 : x1;
        double t3 = dxPos > 0.0 ? xPos : this.getWidth();
        double xr = dz > 0.0 ? this.getWidth() : t3;
        double t4 = dyPos > 0.0 ? xPos : x1;
        double xb = dz > 0.0 ? t4 : x1;
        double t5 = dxPos > 0.0 ? y1 : yPos;
        double yl = dz > 0.0 ? y1 : t5;
        double t6 = dyPos > 0.0 ? (double)this.getOrigin().y : yPos;
        double yt = dz > 0.0 ? t6 : (double)this.getOrigin().y;
        double t7 = dxPos > 0.0 ? yPos : y1;
        double yr = dz > 0.0 ? y1 : t7;
        double t8 = dyPos > 0.0 ? yPos : this.getHeight();
        double yb = dz > 0.0 ? t8 : this.getHeight();
        double u1 = Math.min(this.getHeight(), this.getWidth()) * this.adjustments[2] / 100000.0;
        double u2 = this.getWidth() + 0.0 - u1;
        double v2 = this.getHeight() + 0.0 - u1;
        double il = u1 * 29289.0 / 100000.0;
        double ir = this.getWidth() + 0.0 - il;
        double ib = this.getHeight() + 0.0 - il;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)u1);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * u1, 2.0 * u1), 180.0, -90.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x1, this.getOrigin().y);
        path.lineTo((float)xt, (float)yt);
        path.lineTo((float)x2, this.getOrigin().y);
        path.lineTo((float)u2, this.getOrigin().y);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * u1, 2.0 * u1), 90.0, -90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)this.getWidth(), (float)y1);
        path.lineTo((float)xr, (float)yr);
        path.lineTo((float)this.getWidth(), (float)y2);
        path.lineTo((float)this.getWidth(), (float)v2);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * u1, 2.0 * u1), 360.0, -90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x2, (float)this.getHeight());
        path.lineTo((float)xb, (float)yb);
        path.lineTo((float)x1, (float)this.getHeight());
        path.lineTo((float)u1, (float)this.getHeight());
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * u1, 2.0 * u1), 270.0, -90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo(this.getOrigin().x, (float)y2);
        path.lineTo((float)xl, (float)yl);
        path.lineTo(this.getOrigin().x, (float)y1);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

