/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WedgeEllipseCallout
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{-20833.0, 62500.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double dxPos = this.getWidth() * this.adjustments[0] / 100000.0;
        double dyPos = this.getHeight() * this.adjustments[1] / 100000.0;
        double xPos = this.getWidth() / 2.0 + dxPos - 0.0;
        double yPos = this.getHeight() / 2.0 + dyPos - 0.0;
        double sdx = dxPos * this.getHeight() / 1.0;
        double sdy = dyPos * this.getWidth() / 1.0;
        double pang = 60000.0 * Math.toDegrees(Math.atan2(sdy, sdx));
        double stAng = pang + 660000.0 - 0.0;
        double enAng = pang + 0.0 - 660000.0;
        double dx1 = this.getWidth() / 2.0 * Math.cos(Math.toRadians(stAng / 60000.0));
        double dy1 = this.getHeight() / 2.0 * Math.sin(Math.toRadians(stAng / 60000.0));
        double x1 = this.getWidth() / 2.0 + dx1 - 0.0;
        double y1 = this.getHeight() / 2.0 + dy1 - 0.0;
        double dx2 = this.getWidth() / 2.0 * Math.cos(Math.toRadians(enAng / 60000.0));
        double dy2 = this.getHeight() / 2.0 * Math.sin(Math.toRadians(enAng / 60000.0));
        double x2 = this.getWidth() / 2.0 + dx2 - 0.0;
        double y2 = this.getHeight() / 2.0 + dy2 - 0.0;
        double stAng1 = 60000.0 * Math.toDegrees(Math.atan2(dy1, dx1));
        double enAng1 = 60000.0 * Math.toDegrees(Math.atan2(dy2, dx2));
        double swAng1 = enAng1 + 0.0 - stAng1;
        double swAng2 = swAng1 + 2.16E7 - 0.0;
        double swAng = swAng1 > 0.0 ? swAng1 : swAng2;
        double idx = this.getWidth() / 2.0 * Math.cos(Math.toRadians(45.0));
        double idy = this.getHeight() / 2.0 * Math.sin(Math.toRadians(45.0));
        double il = this.getWidth() / 2.0 + 0.0 - idx;
        double ir = this.getWidth() / 2.0 + idx - 0.0;
        double it = this.getHeight() / 2.0 + 0.0 - idy;
        double ib = this.getHeight() / 2.0 + idy - 0.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)xPos, (float)yPos);
        path.lineTo((float)x1, (float)y1);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * (this.getWidth() / 2.0), 2.0 * (this.getHeight() / 2.0)), 360.0 - stAng1 / 60000.0, swAng / -60000.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

