/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Wave
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{12500.0, 0.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 20000.0) {
            a1 = 20000.0;
        }
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < -10000.0) {
            a2 = -10000.0;
        } else if (this.adjustments[1] > 10000.0) {
            a2 = 10000.0;
        }
        double y1 = this.getHeight() * a1 / 100000.0;
        double dy2 = y1 * 10.0 / 3.0;
        double y2 = y1 + 0.0 - dy2;
        double y3 = y1 + dy2 - 0.0;
        double y4 = this.getHeight() + 0.0 - y1;
        double y5 = y4 + 0.0 - dy2;
        double y6 = y4 + dy2 - 0.0;
        double dx1 = this.getWidth() * a2 / 100000.0;
        double of2 = this.getWidth() * a2 / 50000.0;
        double x1 = Math.abs(dx1);
        double dx2 = of2 > 0.0 ? 0.0 : of2;
        double x2 = (double)(this.getOrigin().x + 0) - dx2;
        double dx5 = of2 > 0.0 ? of2 : 0.0;
        double x5 = this.getWidth() + 0.0 - dx5;
        double dx3 = (dx2 + x5) / 3.0;
        double x3 = x2 + dx3 - 0.0;
        double x4 = (x3 + x5) / 2.0;
        double x6 = (double)this.getOrigin().x + dx5 - 0.0;
        double x10 = this.getWidth() + dx2 - 0.0;
        double x7 = x6 + dx3 - 0.0;
        double x8 = (x7 + x10) / 2.0;
        double x9 = this.getWidth() + 0.0 - x1;
        double xAdj = this.getWidth() / 2.0 + dx1 - 0.0;
        double xAdj2 = this.getWidth() / 2.0 + 0.0 - dx1;
        double il = x2 * Math.cos(Math.toRadians(x6 / 60000.0));
        double ir = Math.min(x5, x10);
        double it = this.getHeight() * a1 / 50000.0;
        double ib = this.getHeight() + 0.0 - it;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)x2, (float)y1);
        path.curveTo((float)x3, (float)y2, (float)x4, (float)y3, (float)x5, (float)y1);
        path.lineTo((float)x10, (float)y4);
        path.curveTo((float)x8, (float)y6, (float)x7, (float)y5, (float)x6, (float)y4);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

