/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class UturnArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 25000.0, 25000.0, 43750.0, 75000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            a2 = 0.0;
        } else if (this.adjustments[1] > 25000.0) {
            a2 = 25000.0;
        }
        double maxAdj1 = a2 * 2.0 / 1.0;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > maxAdj1) {
            a1 = maxAdj1;
        }
        double q2 = a1 * Math.min(this.getHeight(), this.getWidth()) / this.getHeight();
        double q3 = 100000.0 - q2;
        double maxAdj3 = q3 * this.getHeight() / Math.min(this.getHeight(), this.getWidth());
        double a3 = this.adjustments[2];
        if (this.adjustments[2] < 0.0) {
            a3 = 0.0;
        } else if (this.adjustments[2] > maxAdj3) {
            a3 = maxAdj3;
        }
        double q1 = a3 + a1 - 0.0;
        double minAdj5 = q1 * Math.min(this.getHeight(), this.getWidth()) / this.getHeight();
        double a5 = this.adjustments[4];
        if (this.adjustments[4] < minAdj5) {
            a5 = minAdj5;
        } else if (this.adjustments[4] > 100000.0) {
            a5 = 100000.0;
        }
        double th = Math.min(this.getHeight(), this.getWidth()) * a1 / 100000.0;
        double aw2 = Math.min(this.getHeight(), this.getWidth()) * a2 / 100000.0;
        double th2 = th * 1.0 / 2.0;
        double dh2 = aw2 + 0.0 - th2;
        double y5 = this.getHeight() * a5 / 100000.0;
        double ah = Math.min(this.getHeight(), this.getWidth()) * a3 / 100000.0;
        double y4 = y5 + 0.0 - ah;
        double x9 = this.getWidth() + 0.0 - dh2;
        double bw = x9 * 1.0 / 2.0;
        double bs = Math.min(bw, y4);
        double maxAdj4 = bs * 100000.0 / Math.min(this.getHeight(), this.getWidth());
        double a4 = this.adjustments[3];
        if (this.adjustments[3] < 0.0) {
            a4 = 0.0;
        } else if (this.adjustments[3] > maxAdj4) {
            a4 = maxAdj4;
        }
        double bd = Math.min(this.getHeight(), this.getWidth()) * a4 / 100000.0;
        double bd3 = bd + 0.0 - th;
        double bd2 = bd3 * Math.cos(Math.toRadians(0.0));
        double x3 = th + bd2 - 0.0;
        double x8 = this.getWidth() + 0.0 - aw2;
        double x6 = x8 + 0.0 - aw2;
        double x7 = x6 + dh2 - 0.0;
        double x4 = x9 + 0.0 - bd;
        double x5 = x7 + 0.0 - bd2;
        double cx = (th + x7) / 2.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)this.getHeight());
        path.lineTo(this.getOrigin().x, (float)bd);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * bd, 2.0 * bd), 180.0, -90.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x4, this.getOrigin().y);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * bd, 2.0 * bd), 90.0, -90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x9, (float)y4);
        path.lineTo((float)this.getWidth(), (float)y4);
        path.lineTo((float)x8, (float)y5);
        path.lineTo((float)x6, (float)y4);
        path.lineTo((float)x7, (float)y4);
        path.lineTo((float)x7, (float)x3);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * bd2, 2.0 * bd2), 360.0, 90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x3, (float)th);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * bd2, 2.0 * bd2), 90.0, 90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)th, (float)this.getHeight());
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

