/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class SwooshArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 16667.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 1.0) {
            a1 = 1.0;
        } else if (this.adjustments[0] > 75000.0) {
            a1 = 75000.0;
        }
        double maxAdj2 = 70000.0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            a2 = 0.0;
        } else if (this.adjustments[1] > maxAdj2) {
            a2 = maxAdj2;
        }
        double ad1 = this.getHeight() * a1 / 100000.0;
        double ad2 = Math.min(this.getHeight(), this.getWidth()) * a2 / 100000.0;
        double xB = this.getWidth() + 0.0 - ad2;
        double yB = (double)this.getOrigin().y + Math.min(this.getHeight(), this.getWidth()) / 8.0 - 0.0;
        double alfa = 385714.28571428574;
        double dx0 = Math.min(this.getHeight(), this.getWidth()) / 8.0 * Math.tan(Math.toRadians(alfa / 60000.0));
        double xC = xB + 0.0 - dx0;
        double dx1 = ad1 * Math.tan(Math.toRadians(alfa / 60000.0));
        double yF = yB + ad1 - 0.0;
        double xF = xB + dx1 - 0.0;
        double xE = xF + dx0 - 0.0;
        double yE = yF + Math.min(this.getHeight(), this.getWidth()) / 8.0 - 0.0;
        double dy2 = yE + 0.0 - (double)this.getOrigin().y;
        double dy22 = dy2 * 1.0 / 2.0;
        double dy3 = this.getHeight() * 1.0 / 20.0;
        double yD = (double)this.getOrigin().y + dy22 - dy3;
        double dy4 = this.getHeight() / 6.0 * 1.0 / 1.0;
        double yP1 = this.getHeight() / 6.0 + dy4 - 0.0;
        double xP1 = this.getWidth() / 6.0;
        double dy5 = this.getHeight() / 6.0 * 1.0 / 2.0;
        double yP2 = yF + dy5 - 0.0;
        double xP2 = this.getWidth() / 4.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)this.getHeight());
        path.quadTo((float)xP1, (float)yP1, (float)xB, (float)yB);
        path.lineTo((float)xC, this.getOrigin().y);
        path.lineTo((float)this.getWidth(), (float)yD);
        path.lineTo((float)xE, (float)yE);
        path.lineTo((float)xF, (float)yF);
        path.quadTo((float)xP2, (float)yP2, this.getOrigin().x, (float)this.getHeight());
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

