/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Star6
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{28868.0, 115470.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > 50000.0) {
            a = 50000.0;
        }
        double swd2 = this.getWidth() / 2.0 * this.adjustments[1] / 100000.0;
        double dx1 = swd2 * Math.cos(Math.toRadians(30.0));
        double x1 = this.getWidth() / 2.0 + 0.0 - dx1;
        double x2 = this.getWidth() / 2.0 + dx1 - 0.0;
        double y2 = this.getHeight() / 2.0 + this.getHeight() / 4.0 - 0.0;
        double iwd2 = swd2 * a / 50000.0;
        double ihd2 = this.getHeight() / 2.0 * a / 50000.0;
        double sdx2 = iwd2 * 1.0 / 2.0;
        double sx1 = this.getWidth() / 2.0 + 0.0 - iwd2;
        double sx2 = this.getWidth() / 2.0 + 0.0 - sdx2;
        double sx3 = this.getWidth() / 2.0 + sdx2 - 0.0;
        double sx4 = this.getWidth() / 2.0 + iwd2 - 0.0;
        double sdy1 = ihd2 * Math.sin(Math.toRadians(60.0));
        double sy1 = this.getHeight() / 2.0 + 0.0 - sdy1;
        double sy2 = this.getHeight() / 2.0 + sdy1 - 0.0;
        double yAdj = this.getHeight() / 2.0 + 0.0 - ihd2;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)x1, (float)(this.getHeight() / 4.0));
        path.lineTo((float)sx2, (float)sy1);
        path.lineTo((float)(this.getWidth() / 2.0), this.getOrigin().y);
        path.lineTo((float)sx3, (float)sy1);
        path.lineTo((float)x2, (float)(this.getHeight() / 4.0));
        path.lineTo((float)sx4, (float)(this.getHeight() / 2.0));
        path.lineTo((float)x2, (float)y2);
        path.lineTo((float)sx3, (float)sy2);
        path.lineTo((float)(this.getWidth() / 2.0), (float)this.getHeight());
        path.lineTo((float)sx2, (float)sy2);
        path.lineTo((float)x1, (float)y2);
        path.lineTo((float)sx1, (float)(this.getHeight() / 2.0));
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

