/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Star4
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{12500.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > 50000.0) {
            a = 50000.0;
        }
        double iwd2 = this.getWidth() / 2.0 * a / 50000.0;
        double ihd2 = this.getHeight() / 2.0 * a / 50000.0;
        double sdx = iwd2 * Math.cos(Math.toRadians(45.0));
        double sdy = ihd2 * Math.sin(Math.toRadians(45.0));
        double sx1 = this.getWidth() / 2.0 + 0.0 - sdx;
        double sx2 = this.getWidth() / 2.0 + sdx - 0.0;
        double sy1 = this.getHeight() / 2.0 + 0.0 - sdy;
        double sy2 = this.getHeight() / 2.0 + sdy - 0.0;
        double yAdj = this.getHeight() / 2.0 + 0.0 - ihd2;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)(this.getHeight() / 2.0));
        path.lineTo((float)sx1, (float)sy1);
        path.lineTo((float)(this.getWidth() / 2.0), this.getOrigin().y);
        path.lineTo((float)sx2, (float)sy1);
        path.lineTo((float)this.getWidth(), (float)(this.getHeight() / 2.0));
        path.lineTo((float)sx2, (float)sy2);
        path.lineTo((float)(this.getWidth() / 2.0), (float)this.getHeight());
        path.lineTo((float)sx1, (float)sy2);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

