/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Round1Rect
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{16667.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > 50000.0) {
            a = 50000.0;
        }
        double dx1 = Math.min(this.getHeight(), this.getWidth()) * a / 100000.0;
        double x1 = this.getWidth() + 0.0 - dx1;
        double idx = dx1 * 29289.0 / 100000.0;
        double ir = this.getWidth() + 0.0 - idx;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, this.getOrigin().y);
        path.lineTo((float)x1, this.getOrigin().y);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * dx1, 2.0 * dx1), 90.0, -90.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)this.getWidth(), (float)this.getHeight());
        path.lineTo(this.getOrigin().x, (float)this.getHeight());
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

