/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class RightArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{50000.0, 50000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double maxAdj2 = 100000.0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 100000.0) {
            a1 = 100000.0;
        }
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            a2 = 0.0;
        } else if (this.adjustments[1] > maxAdj2) {
            a2 = maxAdj2;
        }
        double dx1 = Math.min(this.getHeight(), this.getWidth()) * a2 / 100000.0;
        double x1 = this.getWidth() + 0.0 - dx1;
        double dy1 = this.getHeight() * a1 / 200000.0;
        double y1 = this.getHeight() / 2.0 + 0.0 - dy1;
        double y2 = this.getHeight() / 2.0 + dy1 - 0.0;
        double dx2 = y1 * dx1 / (this.getHeight() / 2.0);
        double x2 = x1 + dx2 - 0.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)y1);
        path.lineTo((float)x1, (float)y1);
        path.lineTo((float)x1, this.getOrigin().y);
        path.lineTo((float)this.getWidth(), (float)(this.getHeight() / 2.0));
        path.lineTo((float)x1, (float)this.getHeight());
        path.lineTo((float)x1, (float)y2);
        path.lineTo(this.getOrigin().x, (float)y2);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

