/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Parallelogram
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double q3;
        double maxAdj = 100000.0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > maxAdj) {
            a = maxAdj;
        }
        double x1 = Math.min(this.getHeight(), this.getWidth()) * a / 200000.0;
        double x2 = Math.min(this.getHeight(), this.getWidth()) * a / 100000.0;
        double x6 = this.getWidth() + 0.0 - x1;
        double x5 = this.getWidth() + 0.0 - x2;
        double x3 = x5 * 1.0 / 2.0;
        double x4 = this.getWidth() + 0.0 - x3;
        double il = this.getWidth() / 2.0 * a / maxAdj;
        double q1 = 5.0 * a / maxAdj;
        double q2 = (1.0 + q1) / 12.0;
        il = q2 * this.getWidth() / 1.0;
        double it = q2 * this.getHeight() / 1.0;
        double ir = this.getWidth() + 0.0 - il;
        double ib = this.getHeight() + 0.0 - it;
        double y1 = q3 = this.getHeight() * (this.getWidth() / 2.0) / x2;
        if (q3 < 0.0) {
            y1 = 0.0;
        } else if (q3 > this.getHeight()) {
            y1 = this.getHeight();
        }
        double y2 = this.getHeight() + 0.0 - y1;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)this.getHeight());
        path.lineTo((float)x2, this.getOrigin().y);
        path.lineTo((float)this.getWidth(), this.getOrigin().y);
        path.lineTo((float)x5, (float)this.getHeight());
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

