/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Moon
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{50000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > 87500.0) {
            a = 87500.0;
        }
        double g0 = Math.min(this.getHeight(), this.getWidth()) * a / 100000.0;
        double g0w = g0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double g1 = Math.min(this.getHeight(), this.getWidth()) + 0.0 - g0;
        double g2 = g0 * g0 / g1;
        double g3 = Math.min(this.getHeight(), this.getWidth()) * Math.min(this.getHeight(), this.getWidth()) / g1;
        double g4 = g3 * 2.0 / 1.0;
        double g5 = g4 + 0.0 - g2;
        double g6 = g5 + 0.0 - g0;
        double g6w = g6 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double g7 = g5 * 1.0 / 2.0;
        double g8 = g7 + 0.0 - g0;
        double dy1 = g8 * (this.getHeight() / 2.0) / Math.min(this.getHeight(), this.getWidth());
        double g10h = this.getHeight() / 2.0 + 0.0 - dy1;
        double g11h = this.getHeight() / 2.0 + dy1 - 0.0;
        double g12 = g0 * 9598.0 / 32768.0;
        double g12w = g12 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double g13 = Math.min(this.getHeight(), this.getWidth()) + 0.0 - g12;
        double q1 = Math.min(this.getHeight(), this.getWidth()) * Math.min(this.getHeight(), this.getWidth()) / 1.0;
        double q2 = g13 * g13 / 1.0;
        double q3 = q1 + 0.0 - q2;
        double q4 = Math.sqrt(q3);
        double dy4 = q4 * (this.getHeight() / 2.0) / Math.min(this.getHeight(), this.getWidth());
        double g15h = this.getHeight() / 2.0 + 0.0 - dy4;
        double g16h = this.getHeight() / 2.0 + dy4 - 0.0;
        double g17w = g6w + 0.0 - g0w;
        double g18w = g17w * 1.0 / 2.0;
        double dx2p = g0w + g18w - this.getWidth();
        double dx2 = dx2p * -1.0 / 1.0;
        double dy2 = this.getHeight() / 2.0 * -1.0 / 1.0;
        double stAng1 = 60000.0 * Math.toDegrees(Math.atan2(dy2, dx2));
        double enAngp1 = 60000.0 * Math.toDegrees(Math.atan2(this.getHeight() / 2.0, dx2));
        double enAng1 = enAngp1 + 0.0 - 2.16E7;
        double swAng1 = enAng1 + 0.0 - stAng1;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)this.getWidth(), (float)this.getHeight());
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * this.getWidth(), 2.0 * (this.getHeight() / 2.0)), 270.0, -180.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * g18w, 2.0 * dy1), 360.0 - stAng1 / 60000.0, swAng1 / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

