/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class MathNotEqual
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{23520.0, 6600000.0, 11760.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 50000.0) {
            a1 = 50000.0;
        }
        double crAng = this.adjustments[1];
        if (this.adjustments[1] < 4200000.0) {
            crAng = 4200000.0;
        } else if (this.adjustments[1] > 6600000.0) {
            crAng = 6600000.0;
        }
        double a21 = a1 * 2.0 / 1.0;
        double maxAdj3 = 100000.0 - a21;
        double a3 = this.adjustments[2];
        if (this.adjustments[2] < 0.0) {
            a3 = 0.0;
        } else if (this.adjustments[2] > maxAdj3) {
            a3 = maxAdj3;
        }
        double dy1 = this.getHeight() * a1 / 100000.0;
        double dy2 = this.getHeight() * a3 / 200000.0;
        double dx1 = this.getWidth() * 73490.0 / 200000.0;
        double x1 = this.getWidth() / 2.0 + 0.0 - dx1;
        double x8 = this.getWidth() / 2.0 + dx1 - 0.0;
        double y2 = this.getHeight() / 2.0 + 0.0 - dy2;
        double y3 = this.getHeight() / 2.0 + dy2 - 0.0;
        double y1 = y2 + 0.0 - dy1;
        double y4 = y3 + dy1 - 0.0;
        double cadj2 = crAng + 0.0 - 5400000.0;
        double xadj2 = this.getHeight() / 2.0 * Math.tan(Math.toRadians(cadj2 / 60000.0));
        double len = Math.sqrt(xadj2 * xadj2 + this.getHeight() / 2.0 * (this.getHeight() / 2.0) + 0.0);
        double bhw = len * dy1 / (this.getHeight() / 2.0);
        double bhw2 = bhw * 1.0 / 2.0;
        double x7 = this.getWidth() / 2.0 + xadj2 - bhw2;
        double dx67 = xadj2 * y1 / (this.getHeight() / 2.0);
        double x6 = x7 + 0.0 - dx67;
        double dx57 = xadj2 * y2 / (this.getHeight() / 2.0);
        double x5 = x7 + 0.0 - dx57;
        double dx47 = xadj2 * y3 / (this.getHeight() / 2.0);
        double x4 = x7 + 0.0 - dx47;
        double dx37 = xadj2 * y4 / (this.getHeight() / 2.0);
        double x3 = x7 + 0.0 - dx37;
        double dx27 = xadj2 * 2.0 / 1.0;
        double x2 = x7 + 0.0 - dx27;
        double rx7 = x7 + bhw - 0.0;
        double rx6 = x6 + bhw - 0.0;
        double rx5 = x5 + bhw - 0.0;
        double rx4 = x4 + bhw - 0.0;
        double rx3 = x3 + bhw - 0.0;
        double rx2 = x2 + bhw - 0.0;
        double dx7 = dy1 * (this.getHeight() / 2.0) / len;
        double rxt = x7 + dx7 - 0.0;
        double lxt = rx7 + 0.0 - dx7;
        double rx = cadj2 > 0.0 ? rxt : rx7;
        double lx = cadj2 > 0.0 ? x7 : lxt;
        double dy3 = dy1 * xadj2 / len;
        double dy4 = 0.0 - dy3;
        double ry = cadj2 > 0.0 ? dy3 : (double)this.getOrigin().y;
        double ly = cadj2 > 0.0 ? (double)this.getOrigin().y : dy4;
        double dlx = this.getWidth() + 0.0 - rx;
        double drx = this.getWidth() + 0.0 - lx;
        double dly = this.getHeight() + 0.0 - ry;
        double dry = this.getHeight() + 0.0 - ly;
        double xC1 = (rx + lx) / 2.0;
        double xC2 = (drx + dlx) / 2.0;
        double yC1 = (ry + ly) / 2.0;
        double yC2 = (y1 + y2) / 2.0;
        double yC3 = (y3 + y4) / 2.0;
        double yC4 = (dry + dly) / 2.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)x1, (float)y1);
        path.lineTo((float)x6, (float)y1);
        path.lineTo((float)lx, (float)ly);
        path.lineTo((float)rx, (float)ry);
        path.lineTo((float)rx6, (float)y1);
        path.lineTo((float)x8, (float)y1);
        path.lineTo((float)x8, (float)y2);
        path.lineTo((float)rx5, (float)y2);
        path.lineTo((float)rx4, (float)y3);
        path.lineTo((float)x8, (float)y3);
        path.lineTo((float)x8, (float)y4);
        path.lineTo((float)rx3, (float)y4);
        path.lineTo((float)drx, (float)dry);
        path.lineTo((float)dlx, (float)dly);
        path.lineTo((float)x3, (float)y4);
        path.lineTo((float)x1, (float)y4);
        path.lineTo((float)x1, (float)y3);
        path.lineTo((float)x4, (float)y3);
        path.lineTo((float)x5, (float)y2);
        path.lineTo((float)x1, (float)y2);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

