/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class MathMultiply
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{23520.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 51965.0) {
            a1 = 51965.0;
        }
        double th = Math.min(this.getHeight(), this.getWidth()) * a1 / 100000.0;
        double a = 60000.0 * Math.toDegrees(Math.atan2(this.getHeight(), this.getWidth()));
        double sa = 1.0 * Math.sin(Math.toRadians(a / 60000.0));
        double ca = 1.0 * Math.cos(Math.toRadians(a / 60000.0));
        double ta = 1.0 * Math.tan(Math.toRadians(a / 60000.0));
        double dl = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight() + 0.0);
        double rw = dl * 51965.0 / 100000.0;
        double lM = dl + 0.0 - rw;
        double xM = ca * lM / 2.0;
        double yM = sa * lM / 2.0;
        double dxAM = sa * th / 2.0;
        double dyAM = ca * th / 2.0;
        double xA = xM + 0.0 - dxAM;
        double yA = yM + dyAM - 0.0;
        double xB = xM + dxAM - 0.0;
        double yB = yM + 0.0 - dyAM;
        double xBC = this.getWidth() / 2.0 + 0.0 - xB;
        double yBC = xBC * ta / 1.0;
        double yC = yBC + yB - 0.0;
        double xD = this.getWidth() + 0.0 - xB;
        double xE = this.getWidth() + 0.0 - xA;
        double yFE = this.getHeight() / 2.0 + 0.0 - yA;
        double xFE = yFE * 1.0 / ta;
        double xF = xE + 0.0 - xFE;
        double xL = xA + xFE - 0.0;
        double yG = this.getHeight() + 0.0 - yA;
        double yH = this.getHeight() + 0.0 - yB;
        double yI = this.getHeight() + 0.0 - yC;
        double xC2 = this.getWidth() + 0.0 - xM;
        double yC3 = this.getHeight() + 0.0 - yM;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)xA, (float)yA);
        path.lineTo((float)xB, (float)yB);
        path.lineTo((float)(this.getWidth() / 2.0), (float)yC);
        path.lineTo((float)xD, (float)yB);
        path.lineTo((float)xE, (float)yA);
        path.lineTo((float)xF, (float)(this.getHeight() / 2.0));
        path.lineTo((float)xE, (float)yG);
        path.lineTo((float)xD, (float)yH);
        path.lineTo((float)(this.getWidth() / 2.0), (float)yI);
        path.lineTo((float)xB, (float)yH);
        path.lineTo((float)xA, (float)yG);
        path.lineTo((float)xL, (float)(this.getHeight() / 2.0));
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

