/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class LeftUpArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 25000.0, 25000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            a2 = 0.0;
        } else if (this.adjustments[1] > 50000.0) {
            a2 = 50000.0;
        }
        double maxAdj1 = a2 * 2.0 / 1.0;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > maxAdj1) {
            a1 = maxAdj1;
        }
        double maxAdj3 = 100000.0 - maxAdj1;
        double a3 = this.adjustments[2];
        if (this.adjustments[2] < 0.0) {
            a3 = 0.0;
        } else if (this.adjustments[2] > maxAdj3) {
            a3 = maxAdj3;
        }
        double x1 = Math.min(this.getHeight(), this.getWidth()) * a3 / 100000.0;
        double dx2 = Math.min(this.getHeight(), this.getWidth()) * a2 / 50000.0;
        double x2 = this.getWidth() + 0.0 - dx2;
        double y2 = this.getHeight() + 0.0 - dx2;
        double dx4 = Math.min(this.getHeight(), this.getWidth()) * a2 / 100000.0;
        double x4 = this.getWidth() + 0.0 - dx4;
        double y4 = this.getHeight() + 0.0 - dx4;
        double dx3 = Math.min(this.getHeight(), this.getWidth()) * a1 / 200000.0;
        double x3 = x4 + 0.0 - dx3;
        double x5 = x4 + dx3 - 0.0;
        double y3 = y4 + 0.0 - dx3;
        double y5 = y4 + dx3 - 0.0;
        double il = dx3 * x1 / dx4;
        double cx1 = (x1 + x5) / 2.0;
        double cy1 = (x1 + y5) / 2.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)y4);
        path.lineTo((float)x1, (float)y2);
        path.lineTo((float)x1, (float)y3);
        path.lineTo((float)x3, (float)y3);
        path.lineTo((float)x3, (float)x1);
        path.lineTo((float)x2, (float)x1);
        path.lineTo((float)x4, this.getOrigin().y);
        path.lineTo((float)this.getWidth(), (float)x1);
        path.lineTo((float)x5, (float)x1);
        path.lineTo((float)x5, (float)y5);
        path.lineTo((float)x1, (float)y5);
        path.lineTo((float)x1, (float)this.getHeight());
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

