/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Hexagon
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 115470.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double maxAdj = 50000.0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double a = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a = 0.0;
        } else if (this.adjustments[0] > maxAdj) {
            a = maxAdj;
        }
        double shd2 = this.getHeight() / 2.0 * this.adjustments[1] / 100000.0;
        double x1 = Math.min(this.getHeight(), this.getWidth()) * a / 100000.0;
        double x2 = this.getWidth() + 0.0 - x1;
        double dy1 = shd2 * Math.sin(Math.toRadians(60.0));
        double y1 = this.getHeight() / 2.0 + 0.0 - dy1;
        double y2 = this.getHeight() / 2.0 + dy1 - 0.0;
        double q1 = maxAdj * -1.0 / 2.0;
        double q2 = a + q1 - 0.0;
        double q3 = q2 > 0.0 ? 4 : 2;
        double q4 = q2 > 0.0 ? 3 : 2;
        double q5 = q2 > 0.0 ? q1 : 0.0;
        double q6 = (a + q5) / q1;
        double q7 = q6 * q4 / -1.0;
        double q8 = q3 + q7 - 0.0;
        double il = this.getWidth() * q8 / 24.0;
        double it = this.getHeight() * q8 / 24.0;
        double ir = this.getWidth() + 0.0 - il;
        double ib = this.getHeight() + 0.0 - it;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo(this.getOrigin().x, (float)(this.getHeight() / 2.0));
        path.lineTo((float)x1, (float)y1);
        path.lineTo((float)x2, (float)y1);
        path.lineTo((float)this.getWidth(), (float)(this.getHeight() / 2.0));
        path.lineTo((float)x2, (float)y2);
        path.lineTo((float)x1, (float)y2);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

