/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Funnel
implements Autoshape {
    public static double[] DefaultAdjustments = new double[0];
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double d = Math.min(this.getHeight(), this.getWidth()) * 1.0 / 20.0;
        double rw2 = this.getWidth() / 2.0 + 0.0 - d;
        double rh2 = this.getHeight() / 4.0 + 0.0 - d;
        double t1 = this.getWidth() / 2.0 * Math.cos(Math.toRadians(8.0));
        double t2 = this.getHeight() / 4.0 * Math.sin(Math.toRadians(8.0));
        double da = 60000.0 * Math.toDegrees(Math.atan2(t2, t1));
        double d2a = da * 2.0 / 1.0;
        double stAng1 = 1.08E7 - da;
        double swAng1 = 1.08E7 + d2a - 0.0;
        double swAng3 = 1.08E7 - d2a;
        double rw3 = this.getWidth() / 2.0 * 1.0 / 4.0;
        double rh3 = this.getHeight() / 4.0 * 1.0 / 4.0;
        double ct1 = this.getHeight() / 4.0 * Math.cos(Math.toRadians(stAng1 / 60000.0));
        double st1 = this.getWidth() / 2.0 * Math.sin(Math.toRadians(stAng1 / 60000.0));
        double m1 = Math.sqrt(ct1 * ct1 + st1 * st1 + 0.0);
        double n1 = this.getWidth() / 2.0 * (this.getHeight() / 4.0) / m1;
        double dx1 = n1 * Math.cos(Math.toRadians(stAng1 / 60000.0));
        double dy1 = n1 * Math.sin(Math.toRadians(stAng1 / 60000.0));
        double x1 = this.getWidth() / 2.0 + dx1 - 0.0;
        double y1 = this.getHeight() / 4.0 + dy1 - 0.0;
        double ct3 = rh3 * Math.cos(Math.toRadians(da / 60000.0));
        double st3 = rw3 * Math.sin(Math.toRadians(da / 60000.0));
        double m3 = Math.sqrt(ct3 * ct3 + st3 * st3 + 0.0);
        double n3 = rw3 * rh3 / m3;
        double dx3 = n3 * Math.cos(Math.toRadians(da / 60000.0));
        double dy3 = n3 * Math.sin(Math.toRadians(da / 60000.0));
        double x3 = this.getWidth() / 2.0 + dx3 - 0.0;
        double vc3 = this.getHeight() + 0.0 - rh3;
        double y2 = vc3 + dy3 - 0.0;
        double x2 = this.getWidth() / 2.0 + 0.0 - rw2;
        double cd = 2.16E7;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = false;
        path.moveTo((float)x1, (float)y1);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * (this.getWidth() / 2.0), 2.0 * (this.getHeight() / 4.0)), 360.0 - stAng1 / 60000.0, swAng1 / -60000.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x3, (float)y2);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * rw3, 2.0 * rh3), 360.0 - da / 60000.0, swAng3 / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.closePath();
        closed = true;
        path.moveTo((float)x2, (float)(this.getHeight() / 4.0));
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * rw2, 2.0 * rh2), 180.0, 360.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

