/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class EllipseRibbon
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 50000.0, 12500.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 100000.0) {
            a1 = 100000.0;
        }
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 25000.0) {
            a2 = 25000.0;
        } else if (this.adjustments[1] > 75000.0) {
            a2 = 75000.0;
        }
        double q10 = 100000.0 - a1;
        double q11 = q10 * 1.0 / 2.0;
        double q12 = a1 + 0.0 - q11;
        double minAdj3 = 0.0 * Math.cos(Math.toRadians(q12 / 60000.0));
        double a3 = this.adjustments[2];
        if (this.adjustments[2] < minAdj3) {
            a3 = minAdj3;
        } else if (this.adjustments[2] > a1) {
            a3 = a1;
        }
        double dx2 = this.getWidth() * a2 / 200000.0;
        double x2 = this.getWidth() / 2.0 + 0.0 - dx2;
        double x3 = x2 + this.getWidth() / 8.0 - 0.0;
        double x4 = this.getWidth() + 0.0 - x3;
        double x5 = this.getWidth() + 0.0 - x2;
        double x6 = this.getWidth() + 0.0 - this.getWidth() / 8.0;
        double dy1 = this.getHeight() * a3 / 100000.0;
        double f1 = 4.0 * dy1 / this.getWidth();
        double q1 = x3 * x3 / this.getWidth();
        double q2 = x3 + 0.0 - q1;
        double y1 = f1 * q2 / 1.0;
        double cx1 = x3 * 1.0 / 2.0;
        double cy1 = f1 * cx1 / 1.0;
        double cx2 = this.getWidth() + 0.0 - cx1;
        q1 = this.getHeight() * a1 / 100000.0;
        double dy3 = q1 + 0.0 - dy1;
        double q3 = x2 * x2 / this.getWidth();
        double q4 = x2 + 0.0 - q3;
        double q5 = f1 * q4 / 1.0;
        double y3 = q5 + dy3 - 0.0;
        double q6 = dy1 + dy3 - y3;
        double q7 = q6 + dy1 - 0.0;
        double cy3 = q7 + dy3 - 0.0;
        double rh = this.getHeight() + 0.0 - q1;
        double q8 = dy1 * 14.0 / 16.0;
        double y2 = (q8 + rh) / 2.0;
        double y5 = q5 + rh - 0.0;
        double y6 = y3 + rh - 0.0;
        double cx4 = x2 * 1.0 / 2.0;
        double q9 = f1 * cx4 / 1.0;
        double cy4 = q9 + rh - 0.0;
        double cx5 = this.getWidth() + 0.0 - cx4;
        double cy6 = cy3 + rh - 0.0;
        double y7 = y1 + dy3 - 0.0;
        double cy7 = q1 + q1 - y7;
        double y8 = this.getHeight() + 0.0 - dy1;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = true;
        path.moveTo(this.getOrigin().x, this.getOrigin().y);
        path.quadTo((float)cx1, (float)cy1, (float)x3, (float)y1);
        path.lineTo((float)x2, (float)y3);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy3, (float)x5, (float)y3);
        path.lineTo((float)x4, (float)y1);
        path.quadTo((float)cx2, (float)cy1, (float)this.getWidth(), this.getOrigin().y);
        path.lineTo((float)x6, (float)y2);
        path.lineTo((float)this.getWidth(), (float)rh);
        path.quadTo((float)cx5, (float)cy4, (float)x5, (float)y5);
        path.lineTo((float)x5, (float)y6);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy6, (float)x2, (float)y6);
        path.lineTo((float)x2, (float)y5);
        path.quadTo((float)cx4, (float)cy4, this.getOrigin().x, (float)rh);
        path.lineTo((float)(this.getWidth() / 8.0), (float)y2);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
        nofill = true;
        nostroke = true;
        path.moveTo((float)x3, (float)y7);
        path.lineTo((float)x3, (float)y1);
        path.lineTo((float)x2, (float)y3);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy3, (float)x5, (float)y3);
        path.lineTo((float)x4, (float)y1);
        path.lineTo((float)x4, (float)y7);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy7, (float)x3, (float)y7);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
        nofill = true;
        nostroke = false;
        path.moveTo(this.getOrigin().x, this.getOrigin().y);
        path.quadTo((float)cx1, (float)cy1, (float)x3, (float)y1);
        path.lineTo((float)x2, (float)y3);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy3, (float)x5, (float)y3);
        path.lineTo((float)x4, (float)y1);
        path.quadTo((float)cx2, (float)cy1, (float)this.getWidth(), this.getOrigin().y);
        path.lineTo((float)x6, (float)y2);
        path.lineTo((float)this.getWidth(), (float)rh);
        path.quadTo((float)cx5, (float)cy4, (float)x5, (float)y5);
        path.lineTo((float)x5, (float)y6);
        path.quadTo((float)(this.getWidth() / 2.0), (float)cy6, (float)x2, (float)y6);
        path.lineTo((float)x2, (float)y5);
        path.quadTo((float)cx4, (float)cy4, this.getOrigin().x, (float)rh);
        path.lineTo((float)(this.getWidth() / 8.0), (float)y2);
        path.closePath();
        closed = true;
        path.moveTo((float)x2, (float)y5);
        path.lineTo((float)x2, (float)y3);
        path.moveTo((float)x5, (float)y3);
        path.lineTo((float)x5, (float)y5);
        path.moveTo((float)x3, (float)y1);
        path.lineTo((float)x3, (float)y7);
        path.moveTo((float)x4, (float)y7);
        path.lineTo((float)x4, (float)y1);
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

