/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CurvedDownArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{25000.0, 50000.0, 25000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double maxAdj2 = 50000.0 * this.getWidth() / Math.min(this.getHeight(), this.getWidth());
        double a2 = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            a2 = 0.0;
        } else if (this.adjustments[1] > maxAdj2) {
            a2 = maxAdj2;
        }
        double a1 = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            a1 = 0.0;
        } else if (this.adjustments[0] > 100000.0) {
            a1 = 100000.0;
        }
        double th = Math.min(this.getHeight(), this.getWidth()) * a1 / 100000.0;
        double aw = Math.min(this.getHeight(), this.getWidth()) * a2 / 100000.0;
        double q1 = (th + aw) / 4.0;
        double wR = this.getWidth() / 2.0 + 0.0 - q1;
        double q7 = wR * 2.0 / 1.0;
        double q8 = q7 * q7 / 1.0;
        double q9 = th * th / 1.0;
        double q10 = q8 + 0.0 - q9;
        double q11 = Math.sqrt(q10);
        double idy = q11 * this.getHeight() / q7;
        double maxAdj3 = 100000.0 * idy / Math.min(this.getHeight(), this.getWidth());
        double a3 = this.adjustments[2];
        if (this.adjustments[2] < 0.0) {
            a3 = 0.0;
        } else if (this.adjustments[2] > maxAdj3) {
            a3 = maxAdj3;
        }
        double ah = Math.min(this.getHeight(), this.getWidth()) * this.adjustments[2] / 100000.0;
        double x3 = wR + th - 0.0;
        double q2 = this.getHeight() * this.getHeight() / 1.0;
        double q3 = ah * ah / 1.0;
        double q4 = q2 + 0.0 - q3;
        double q5 = Math.sqrt(q4);
        double dx = q5 * wR / this.getHeight();
        double x5 = wR + dx - 0.0;
        double x7 = x3 + dx - 0.0;
        double q6 = aw + 0.0 - th;
        double dh = q6 * 1.0 / 2.0;
        double x4 = x5 + 0.0 - dh;
        double x8 = x7 + dh - 0.0;
        double aw2 = aw * 1.0 / 2.0;
        double x6 = this.getWidth() + 0.0 - aw2;
        double y1 = this.getHeight() + 0.0 - ah;
        double swAng = 60000.0 * Math.toDegrees(Math.atan2(dx, ah));
        double mswAng = 0.0 - swAng;
        double iy = this.getHeight() + 0.0 - idy;
        double ix = (wR + x3) / 2.0;
        double q12 = th * 1.0 / 2.0;
        double dang2 = 60000.0 * Math.toDegrees(Math.atan2(q12, idy));
        double stAng = 1.62E7 + swAng - 0.0;
        double stAng2 = 1.62E7 - dang2;
        double swAng2 = dang2 + 0.0 - 5400000.0;
        double swAng3 = 5400000.0 + dang2 - 0.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = true;
        path.moveTo((float)x6, (float)this.getHeight());
        path.lineTo((float)x4, (float)y1);
        path.lineTo((float)x5, (float)y1);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 360.0 - stAng / 60000.0, mswAng / -60000.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x3, this.getOrigin().y);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 90.0, swAng / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x8, (float)y1);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
        nofill = true;
        nostroke = true;
        path.moveTo((float)ix, (float)iy);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 360.0 - stAng2 / 60000.0, swAng2 / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo(this.getOrigin().x, (float)this.getHeight());
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 180.0, swAng3 / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
        nofill = true;
        nostroke = false;
        path.moveTo((float)ix, (float)iy);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 360.0 - stAng2 / 60000.0, swAng2 / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo(this.getOrigin().x, (float)this.getHeight());
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 180.0, -90.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x3, this.getOrigin().y);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 90.0, swAng / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)x8, (float)y1);
        path.lineTo((float)x6, (float)this.getHeight());
        path.lineTo((float)x4, (float)y1);
        path.lineTo((float)x5, (float)y1);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * wR, 2.0 * this.getHeight()), 360.0 - stAng / 60000.0, mswAng / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

