/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class CurvedConnector4
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{50000.0, 50000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double x2 = this.getWidth() * this.adjustments[0] / 100000.0;
        double x1 = ((double)this.getOrigin().x + x2) / 2.0;
        double x3 = (this.getWidth() + x2) / 2.0;
        double x4 = (x2 + x3) / 2.0;
        double x5 = (x3 + this.getWidth()) / 2.0;
        double y4 = this.getHeight() * this.adjustments[1] / 100000.0;
        double y1 = ((double)this.getOrigin().y + y4) / 2.0;
        double y2 = ((double)this.getOrigin().y + y1) / 2.0;
        double y3 = (y1 + y4) / 2.0;
        double y5 = (this.getHeight() + y4) / 2.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = true;
        nostroke = false;
        path.moveTo(this.getOrigin().x, this.getOrigin().y);
        path.curveTo((float)x1, this.getOrigin().y, (float)x2, (float)y2, (float)x2, (float)y1);
        path.curveTo((float)x2, (float)y3, (float)x4, (float)y4, (float)x3, (float)y4);
        path.curveTo((float)x5, (float)y4, (float)this.getWidth(), (float)y5, (float)this.getWidth(), (float)this.getHeight());
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

