/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen.xml;

import com.benryan.ppt.autoshapes.Autoshape;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Arc
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{1.62E7, 0.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private Point2D extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            this.adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            this.adjustments = newAdjustments;
        } else {
            this.adjustments = adjustments;
        }
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        double stAng = this.adjustments[0];
        if (this.adjustments[0] < 0.0) {
            stAng = 0.0;
        } else if (this.adjustments[0] > 2.1599999E7) {
            stAng = 2.1599999E7;
        }
        double enAng = this.adjustments[1];
        if (this.adjustments[1] < 0.0) {
            enAng = 0.0;
        } else if (this.adjustments[1] > 2.1599999E7) {
            enAng = 2.1599999E7;
        }
        double sw11 = enAng + 0.0 - stAng;
        double sw12 = sw11 + 2.16E7 - 0.0;
        double swAng = sw11 > 0.0 ? sw11 : sw12;
        double wt1 = this.getWidth() / 2.0 * Math.sin(Math.toRadians(stAng / 60000.0));
        double ht1 = this.getHeight() / 2.0 * Math.cos(Math.toRadians(stAng / 60000.0));
        double dx1 = this.getWidth() / 2.0 * Math.cos(Math.atan2(wt1, ht1));
        double dy1 = this.getHeight() / 2.0 * Math.sin(Math.atan2(wt1, ht1));
        double wt2 = this.getWidth() / 2.0 * Math.sin(Math.toRadians(enAng / 60000.0));
        double ht2 = this.getHeight() / 2.0 * Math.cos(Math.toRadians(enAng / 60000.0));
        double dx2 = this.getWidth() / 2.0 * Math.cos(Math.atan2(wt2, ht2));
        double dy2 = this.getHeight() / 2.0 * Math.sin(Math.atan2(wt2, ht2));
        double x1 = this.getWidth() / 2.0 + dx1 - 0.0;
        double y1 = this.getHeight() / 2.0 + dy1 - 0.0;
        double x2 = this.getWidth() / 2.0 + dx2 - 0.0;
        double y2 = this.getHeight() / 2.0 + dy2 - 0.0;
        double sw0 = 2.16E7 - stAng;
        double da1 = swAng + 0.0 - sw0;
        double g1 = x1 * Math.cos(Math.toRadians(x2 / 60000.0));
        double ir = da1 > 0.0 ? this.getWidth() : g1;
        double sw1 = 5400000.0 - stAng;
        double sw2 = 2.7E7 - stAng;
        double sw3 = sw1 > 0.0 ? sw1 : sw2;
        double da2 = swAng + 0.0 - sw3;
        double g5 = y1 * Math.cos(Math.toRadians(y2 / 60000.0));
        double ib = da2 > 0.0 ? this.getHeight() : g5;
        double sw4 = 1.08E7 - stAng;
        double sw5 = 3.24E7 - stAng;
        double sw6 = sw4 > 0.0 ? sw4 : sw5;
        double da3 = swAng + 0.0 - sw6;
        double g9 = Math.min(x1, x2);
        double il = da3 > 0.0 ? (double)this.getOrigin().x : g9;
        double sw7 = 1.62E7 - stAng;
        double sw8 = 3.78E7 - stAng;
        double sw9 = sw7 > 0.0 ? sw7 : sw8;
        double da4 = swAng + 0.0 - sw9;
        double g13 = Math.min(y1, y2);
        double it = da4 > 0.0 ? (double)this.getOrigin().y : g13;
        double cang1 = stAng + 0.0 - 5400000.0;
        double cang2 = enAng + 5400000.0 - 0.0;
        double cang3 = (cang1 + cang2) / 2.0;
        boolean nofill = false;
        boolean nostroke = false;
        boolean closed = false;
        Shape sh = path = new GeneralPath();
        nofill = false;
        nostroke = true;
        path.moveTo((float)x1, (float)y1);
        Arc2D.Double tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * (this.getWidth() / 2.0), 2.0 * (this.getHeight() / 2.0)), 360.0 - stAng / 60000.0, swAng / -60000.0, 0);
        AffineTransform tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        Shape tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        path.lineTo((float)(this.getWidth() / 2.0), (float)(this.getHeight() / 2.0));
        path.closePath();
        closed = true;
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
        nofill = true;
        nostroke = false;
        path.moveTo((float)x1, (float)y1);
        tempArc = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, 2.0 * (this.getWidth() / 2.0), 2.0 * (this.getHeight() / 2.0)), 360.0 - stAng / 60000.0, swAng / -60000.0, 0);
        tempAf = AffineTransform.getTranslateInstance(path.getCurrentPoint().getX() - tempArc.getStartPoint().getX(), path.getCurrentPoint().getY() - tempArc.getStartPoint().getY());
        tempShape = tempAf.createTransformedShape(tempArc);
        path.append(tempShape, true);
        sh = at.createTransformedShape(path);
        if (!nofill && closed && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return this.extent.getX();
    }

    @Override
    public double getHeight() {
        return this.extent.getY();
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
        this.extent = new Point2D.Double(width, height);
    }
}

